/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneEntityBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.EntityFilterPair;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetEntityAttack;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;

public class ProgWidgetEntityRightClick
extends ProgWidget
implements IAreaProvider,
IEntityProvider {
    private EntityFilterPair<ProgWidgetEntityRightClick> entityFilters;

    public ProgWidgetEntityRightClick() {
        super(ModProgWidgets.ENTITY_RIGHT_CLICK.get());
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.getConnectedParameters()[0] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
        EntityFilterPair.addErrors(this, curInfo);
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA.get(), ModProgWidgets.TEXT.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ENTITY_RIGHT_CLICK;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget progWidget) {
        return new DroneEntityBase<IEntityProvider, LivingEntity>(drone, (IEntityProvider)((Object)progWidget)){
            private final Set<Entity> visitedEntities;
            {
                this.visitedEntities = new HashSet<Entity>();
            }

            @Override
            protected boolean isEntityValid(Entity entity) {
                return entity instanceof LivingEntity && !this.visitedEntities.contains(entity);
            }

            @Override
            protected boolean doAction() {
                this.visitedEntities.add(this.targetedEntity);
                ItemStack stack = this.drone.getInv().getStackInSlot(0);
                FakePlayer fakePlayer = this.drone.getFakePlayer();
                if (stack.getItem().interactLivingEntity(stack, (Player)fakePlayer, (LivingEntity)this.targetedEntity, InteractionHand.MAIN_HAND).consumesAction() || ((LivingEntity)this.targetedEntity).interact((Player)fakePlayer, InteractionHand.MAIN_HAND).consumesAction()) {
                    for (int i = 0; i < fakePlayer.getInventory().items.size(); ++i) {
                        ItemStack fakePlayerStack = (ItemStack)fakePlayer.getInventory().items.get(i);
                        if (i < this.drone.getInv().getSlots()) {
                            this.drone.getInv().setStackInSlot(i, fakePlayerStack);
                            continue;
                        }
                        if (fakePlayerStack.isEmpty()) continue;
                        this.drone.dropItem(fakePlayerStack);
                        fakePlayer.getInventory().items.set(i, (Object)ItemStack.EMPTY);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public List<Entity> getValidEntities(Level world) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetEntityRightClick>(this);
        }
        return this.entityFilters.getValidEntities(world);
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetEntityRightClick>(this);
        }
        return this.entityFilters.isEntityValid(entity);
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        ProgWidgetEntityAttack.getArea(area, (ProgWidgetArea)this.getConnectedParameters()[0], (ProgWidgetArea)this.getConnectedParameters()[2]);
    }
}

