/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJumpBackWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class ProgWidgetForEachItem
extends ProgWidget
implements IJumpBackWidget,
IJump,
IVariableSetWidget {
    private String elementVariable = "";
    private int curIndex;
    private DroneAIManager aiManager;

    public ProgWidgetForEachItem() {
        super(ModProgWidgets.FOR_EACH_ITEM.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.YELLOW;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_FOR_EACH_ITEM;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.ITEM_FILTER.get(), ModProgWidgets.TEXT.get());
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.elementVariable);
    }

    @Override
    public String getVariable() {
        return this.elementVariable;
    }

    @Override
    public void setVariable(String variable) {
        this.elementVariable = variable;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        if (!this.elementVariable.isEmpty()) {
            tag.putString("variable", this.elementVariable);
        }
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.elementVariable = tag.getString("variable");
        super.readFromNBT(tag);
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeUtf(this.elementVariable);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.elementVariable = buf.readUtf(64);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        List<String> locations = this.getPossibleJumpLocations();
        ItemStack filter = this.getFilterForIndex(this.curIndex++);
        if (!(locations.size() <= 0 || filter.isEmpty() || this.curIndex != 1 && this.aiManager.getStack(drone.getOwnerUUID(), this.elementVariable).isEmpty())) {
            this.aiManager.setStack(this.elementVariable, filter);
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, locations.get(0));
        }
        this.curIndex = 0;
        return super.getOutputWidget(drone, allWidgets);
    }

    @Nonnull
    private ItemStack getFilterForIndex(int index) {
        ProgWidgetItemFilter widget = (ProgWidgetItemFilter)this.getConnectedParameters()[0];
        for (int i = 0; i < index; ++i) {
            if (widget == null) {
                return ItemStack.EMPTY;
            }
            widget = (ProgWidgetItemFilter)widget.getConnectedParameters()[0];
        }
        return widget != null ? widget.getFilter() : ItemStack.EMPTY;
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        IProgWidget widget = this.getConnectedParameters()[this.getParameters().size() - 1];
        ProgWidgetText textWidget = widget != null ? (ProgWidgetText)widget : null;
        ArrayList<String> locations = new ArrayList<String>();
        if (textWidget != null) {
            locations.add(textWidget.string);
        }
        return locations;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.singletonList(this.varAsTextComponent(this.elementVariable));
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }
}

