/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemAssign;
import me.desht.pneumaticcraft.common.item.TagFilterItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class ProgWidgetItemFilter
extends ProgWidget
implements IVariableWidget {
    private ItemStack filter = ItemStack.EMPTY;
    public boolean useItemDurability;
    public boolean useNBT;
    public boolean useModSimilarity;
    public boolean matchBlock;
    private DroneAIManager aiManager;
    private String variable = "";

    public ProgWidgetItemFilter() {
        super(ModProgWidgets.ITEM_FILTER.get());
    }

    public static ProgWidgetItemFilter withFilter(ItemStack filter) {
        ProgWidgetItemFilter widget = new ProgWidgetItemFilter();
        widget.filter = filter;
        return widget;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.isEmpty() && this.filter == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.error.noFilter", new Object[0]));
        }
        if (this.matchBlock && !(this.filter.getItem() instanceof BlockItem) && this.variable.isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.error.notBlock", new Object[0]));
        }
    }

    @Override
    public void addWarnings(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addWarnings(curInfo, widgets);
        int n = 1;
        for (IProgWidget p = this.getParent(); p != null; p = p.getParent()) {
            if (p instanceof ProgWidgetItemAssign && n > 1) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.warning.ignoredItemAssign", new Object[0]));
                break;
            }
            ++n;
        }
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return this.variable.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.varAsTextComponent(this.variable));
    }

    @Nonnull
    public ItemStack getFilter() {
        return this.variable.isEmpty() ? this.filter : (this.aiManager != null ? this.aiManager.getStack(this.aiManager.getDrone().getOwnerUUID(), this.variable) : ItemStack.EMPTY);
    }

    public ItemStack getRawFilter() {
        return this.filter;
    }

    public void setFilter(@Nonnull ItemStack filter) {
        this.filter = filter.copy();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.variable.isEmpty()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.variable", new Object[0]).append(": ").append(this.varAsTextComponent(this.variable)).withStyle(ChatFormatting.AQUA));
        } else if (!this.filter.isEmpty()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.filterLabel", new Object[0]).withStyle(ChatFormatting.AQUA).append(": ").append(this.filter.getHoverName()));
            if (this.filter.getItem() == ModItems.TAG_FILTER.get()) {
                curTooltip.addAll(TagFilterItem.getConfiguredTagList(this.filter).stream().map(s -> Symbols.bullet().append((Component)Component.literal((String)s.location().toString()).withStyle(ChatFormatting.YELLOW))).toList());
            }
        }
        if (this.useModSimilarity) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.matchMod", ModNameCache.getModName(this.filter.getItem())).withStyle(ChatFormatting.DARK_AQUA));
        } else if (this.matchBlock) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.matchBlock", new Object[0]).withStyle(ChatFormatting.DARK_AQUA));
        } else {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter." + (this.useItemDurability ? "useDurability" : "ignoreDurability"), new Object[0]).withStyle(ChatFormatting.DARK_AQUA));
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter." + (this.useNBT ? "useNBT" : "ignoreNBT"), new Object[0]).withStyle(ChatFormatting.DARK_AQUA));
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return ModProgWidgets.ITEM_FILTER.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.ITEM_FILTER.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ITEM_FILTER;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (!this.filter.isEmpty()) {
            this.filter.save(tag);
        }
        if (this.useItemDurability) {
            tag.putBoolean("useMetadata", true);
        }
        if (this.useNBT) {
            tag.putBoolean("useNBT", true);
        }
        if (this.useModSimilarity) {
            tag.putBoolean("useModSimilarity", true);
        }
        if (this.matchBlock) {
            tag.putBoolean("matchBlock", true);
        }
        if (!this.variable.isEmpty()) {
            tag.putString("variable", this.variable);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.filter = ItemStack.of((CompoundTag)tag);
        this.useItemDurability = this.filter.getMaxDamage() > 0 && tag.getBoolean("useMetadata");
        this.useNBT = tag.getBoolean("useNBT");
        this.useModSimilarity = tag.getBoolean("useModSimilarity");
        this.matchBlock = tag.getBoolean("matchBlock");
        this.variable = tag.getString("variable");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeItem(this.filter);
        buf.writeBoolean(this.useItemDurability);
        buf.writeBoolean(this.useNBT);
        buf.writeBoolean(this.useModSimilarity);
        buf.writeBoolean(this.matchBlock);
        buf.writeUtf(this.variable);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.filter = buf.readItem();
        this.useItemDurability = buf.readBoolean();
        this.useNBT = buf.readBoolean();
        this.useModSimilarity = buf.readBoolean();
        this.matchBlock = buf.readBoolean();
        this.variable = buf.readUtf(64);
    }

    public static boolean isItemValidForFilters(ItemStack item, List<ProgWidgetItemFilter> whitelist, List<ProgWidgetItemFilter> blacklist, BlockState blockState) {
        if (blacklist != null) {
            for (ProgWidgetItemFilter black : blacklist) {
                if (!ProgWidgetItemFilter.matchFilter(item, blockState, black)) continue;
                return false;
            }
        }
        if (whitelist == null || whitelist.size() == 0) {
            return true;
        }
        for (ProgWidgetItemFilter white : whitelist) {
            if (!ProgWidgetItemFilter.matchFilter(item, blockState, white)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchFilter(ItemStack stack, BlockState blockState, ProgWidgetItemFilter filter) {
        if (filter.matchBlock && blockState != null && filter.getFilter().getItem() instanceof BlockItem) {
            return blockState.getBlock() == ((BlockItem)filter.getFilter().getItem()).getBlock();
        }
        if (PneumaticCraftUtils.doesItemMatchFilter(filter.getFilter(), stack, filter.useItemDurability && blockState == null, filter.useNBT, filter.useModSimilarity)) {
            return blockState == null || !filter.useItemDurability;
        }
        return false;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GRAY;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }
}

