/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ProgWidgetPressureCondition
extends ProgWidgetCondition {
    public ProgWidgetPressureCondition() {
        super(ModProgWidgets.CONDITION_PRESSURE.get());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA.get(), ModProgWidgets.TEXT.get());
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                BlockEntity te = this.drone.world().getBlockEntity(pos);
                if (te != null) {
                    float pressure = Float.MIN_VALUE;
                    for (Direction dir : DirectionUtil.VALUES) {
                        if (!ProgWidgetPressureCondition.this.getSides()[dir.get3DDataValue()]) continue;
                        float p = PNCCapabilities.getAirHandler(te, dir).map(IAirHandler::getPressure).orElse(Float.valueOf(0.0f)).floatValue();
                        pressure = Math.max(pressure, p);
                    }
                    ProgWidgetPressureCondition.this.maybeRecordMeasuredVal(this.drone, (int)(pressure * 1000.0f));
                    return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(pressure, (float)((ICondition)((Object)this.progWidget)).getRequiredCount());
                }
                return false;
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_PRESSURE;
    }
}

