/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public abstract class AreaType {
    private final String translationKey;
    private final String name;

    public AreaType(String name) {
        this.name = name;
        this.translationKey = String.format("pneumaticcraft.gui.progWidget.area.type.%s.name", name);
    }

    public String getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public abstract void addArea(Consumer<BlockPos> var1, BlockPos var2, BlockPos var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldType, int typeInfo) {
    }

    public boolean isDeterministic() {
        return true;
    }

    public void writeToPacket(FriendlyByteBuf buffer) {
    }

    public void readFromPacket(FriendlyByteBuf buf) {
    }

    public void writeToNBT(CompoundTag tag) {
    }

    public void readFromNBT(CompoundTag tag) {
    }

    public void addUIWidgets(List<AreaTypeWidget> widgets) {
    }

    public static class AreaTypeWidgetEnum<E extends ITranslatableEnum>
    extends AreaTypeWidget {
        public final Class<E> enumClass;
        public final Supplier<E> readAction;
        public final Consumer<E> writeAction;

        public AreaTypeWidgetEnum(String title, Class<E> enumClass, Supplier<E> readAction, Consumer<E> writeAction) {
            super(title);
            this.enumClass = enumClass;
            this.readAction = readAction;
            this.writeAction = writeAction;
        }

        @Override
        public Component getDisplayName() {
            return Component.translatable((String)((ITranslatableEnum)this.readAction.get()).getTranslationKey());
        }
    }

    public static class AreaTypeWidgetInteger
    extends AreaTypeWidget {
        public final IntSupplier readAction;
        public final IntConsumer writeAction;

        public AreaTypeWidgetInteger(String title, IntSupplier readAction, IntConsumer writeAction) {
            super(title);
            this.readAction = readAction;
            this.writeAction = writeAction;
        }

        @Override
        public Component getDisplayName() {
            return Component.literal((String)Integer.toString(this.readAction.getAsInt()));
        }
    }

    public static abstract class AreaTypeWidget {
        public final String title;

        public AreaTypeWidget(String title) {
            this.title = title;
        }

        public abstract Component getDisplayName();
    }

    public static enum EnumAxis implements ITranslatableEnum
    {
        X("x"),
        Y("y"),
        Z("z");

        private final String name;

        private EnumAxis(String name) {
            this.name = "pneumaticcraft.gui.progWidget.area.type.axis." + name;
        }

        @Override
        public String getTranslationKey() {
            return this.name;
        }
    }
}

