/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class AreaTypeCylinder
extends AreaType {
    public static final String ID = "cylinder";
    private AreaType.EnumAxis axis = AreaType.EnumAxis.X;
    private EnumCylinderType cylinderType = EnumCylinderType.FILLED;

    public AreaTypeCylinder() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.cylinderType + "/" + this.axis;
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                double rad = PneumaticCraftUtils.distBetween(p1.getY(), (double)p1.getZ(), (double)p2.getY(), (double)p2.getZ());
                double radSq = rad * rad;
                double innerRadius = rad - 1.0;
                double innerRadiusSq = innerRadius * innerRadius;
                minY = (int)((double)p1.getY() - rad - 1.0);
                minZ = (int)((double)p1.getZ() - rad - 1.0);
                maxY = (int)((double)p1.getY() + rad + 1.0);
                maxZ = (int)((double)p1.getZ() + rad + 1.0);
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        double centerDistSq = PneumaticCraftUtils.distBetweenSq(p1.getY(), (double)p1.getZ(), (double)y, (double)z);
                        if (!(centerDistSq <= radSq)) continue;
                        for (int x = minX; x <= maxX; ++x) {
                            if (!(centerDistSq >= innerRadiusSq) && this.cylinderType != EnumCylinderType.FILLED && (this.cylinderType != EnumCylinderType.HOLLOW || x != minX && x != maxX)) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case Y: {
                double rad = PneumaticCraftUtils.distBetween(p1.getX(), (double)p1.getZ(), (double)p2.getX(), (double)p2.getZ());
                double radSq = rad * rad;
                double innerRadius = rad - 1.0;
                double innerRadiusSq = innerRadius * innerRadius;
                minX = (int)((double)p1.getX() - rad - 1.0);
                minZ = (int)((double)p1.getZ() - rad - 1.0);
                maxX = (int)((double)p1.getX() + rad + 1.0);
                maxZ = (int)((double)p1.getZ() + rad + 1.0);
                for (int x = minX; x <= maxX; ++x) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        double centerDistSq = PneumaticCraftUtils.distBetweenSq(p1.getX(), (double)p1.getZ(), (double)x, (double)z);
                        if (!(centerDistSq <= radSq)) continue;
                        for (int y = minY; y <= maxY; ++y) {
                            if (!(centerDistSq >= innerRadiusSq) && this.cylinderType != EnumCylinderType.FILLED && (this.cylinderType != EnumCylinderType.HOLLOW || y != minY && y != maxY)) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            case Z: {
                double rad = PneumaticCraftUtils.distBetween(p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
                double radSq = rad * rad;
                double innerRadius = rad - 1.0;
                double innerRadiusSq = innerRadius * innerRadius;
                minX = (int)((double)p1.getX() - rad - 1.0);
                minY = (int)((double)p1.getY() - rad - 1.0);
                maxX = (int)((double)p1.getX() + rad + 1.0);
                maxY = (int)((double)p1.getY() + rad + 1.0);
                for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        double centerDistSq = PneumaticCraftUtils.distBetweenSq(p1.getX(), (double)p1.getY(), (double)x, (double)y);
                        if (!(centerDistSq <= radSq)) continue;
                        for (int z = minZ; z <= maxZ; ++z) {
                            if (!(centerDistSq >= innerRadiusSq) && this.cylinderType != EnumCylinderType.FILLED && (this.cylinderType != EnumCylinderType.HOLLOW || z != minZ && z != maxZ)) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<EnumCylinderType>("pneumaticcraft.gui.progWidget.area.type.cylinder.cylinderType", EnumCylinderType.class, () -> this.cylinderType, cylinderType -> {
            this.cylinderType = cylinderType;
        }));
        widgets.add(new AreaType.AreaTypeWidgetEnum<AreaType.EnumAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.EnumAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putByte("axis", (byte)this.axis.ordinal());
        tag.putByte("cylinderType", (byte)this.cylinderType.ordinal());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.axis = AreaType.EnumAxis.values()[tag.getByte("axis")];
        this.cylinderType = EnumCylinderType.values()[tag.getByte("cylinderType")];
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.writeEnum((Enum)this.axis);
        buffer.writeEnum((Enum)this.cylinderType);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.axis = (AreaType.EnumAxis)buf.readEnum(AreaType.EnumAxis.class);
        this.cylinderType = (EnumCylinderType)buf.readEnum(EnumCylinderType.class);
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_CYLINDER: {
                this.axis = AreaType.EnumAxis.X;
                break;
            }
            case Y_CYLINDER: {
                this.axis = AreaType.EnumAxis.Y;
                break;
            }
            case Z_CYLINDER: {
                this.axis = AreaType.EnumAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static enum EnumCylinderType implements ITranslatableEnum
    {
        FILLED("filled"),
        HOLLOW("hollow"),
        TUBE("tube");

        private final String name;

        private EnumCylinderType(String name) {
            this.name = "pneumaticcraft.gui.progWidget.area.type.cylinder.cylinderType." + name;
        }

        @Override
        public String getTranslationKey() {
            return this.name;
        }
    }
}

