/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class AreaTypePyramid
extends AreaType {
    public static final String ID = "pyramid";
    private AreaType.EnumAxis axis = AreaType.EnumAxis.X;
    private EnumAreaTypePyramid pyramidType = EnumAreaTypePyramid.FILLED;

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                if (p2.getX() == p1.getX()) break;
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), (double)(p2.getY() - p1.getY()), (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x, lineVec.y / lineVec.x, lineVec.z / lineVec.x);
                double curY = (double)p1.getY() - lineVec.y;
                int x = p1.getX() + (p2.getX() > p1.getX() ? -1 : 1);
                double curZ = (double)p1.getZ() - lineVec.z;
                int prevDY = -1;
                int prevDZ = -1;
                while (x != p2.getX()) {
                    x += p2.getX() > p1.getX() ? 1 : -1;
                    int dY = Math.abs((int)((curY += lineVec.y) - (double)p1.getY()));
                    int dZ = Math.abs((int)((curZ += lineVec.z) - (double)p1.getZ()));
                    if (dY == prevDY) {
                        --prevDY;
                    }
                    if (dZ == prevDZ) {
                        --prevDZ;
                    }
                    for (int y = p1.getY() - dY; y <= p1.getY() + dY; ++y) {
                        for (int z = p1.getZ() - dZ; z <= p1.getZ() + dZ; ++z) {
                            if (this.pyramidType != EnumAreaTypePyramid.FILLED && x != p2.getX() && z >= p1.getZ() - prevDZ && z <= p1.getZ() + prevDZ && y >= p1.getY() - prevDY && y <= p1.getY() + prevDY) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDY = dY;
                    prevDZ = dZ;
                }
                break;
            }
            case Y: {
                if (p2.getY() == p1.getY()) break;
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), (double)(p2.getY() - p1.getY()), (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x / lineVec.y, lineVec.y, lineVec.z / lineVec.y);
                double curX = (double)p1.getX() - lineVec.x;
                int y = p1.getY() + (p2.getY() > p1.getY() ? -1 : 1);
                double curZ = (double)p1.getZ() - lineVec.z;
                int prevDX = -1;
                int prevDZ = -1;
                while (y != p2.getY()) {
                    y += p2.getY() > p1.getY() ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.x) - (double)p1.getX()));
                    int dZ = Math.abs((int)((curZ += lineVec.z) - (double)p1.getZ()));
                    if (dX == prevDX) {
                        --prevDX;
                    }
                    if (dZ == prevDZ) {
                        --prevDZ;
                    }
                    int miniX = p1.getX() - dX;
                    int maxiX = p1.getX() + dX;
                    int miniZ = p1.getZ() - dZ;
                    int maxiZ = p1.getZ() + dZ;
                    for (int x = miniX; x <= maxiX; ++x) {
                        for (int z = miniZ; z <= maxiZ; ++z) {
                            if (this.pyramidType != EnumAreaTypePyramid.FILLED && y != p2.getY() && z >= p1.getZ() - prevDZ && z <= p1.getZ() + prevDZ && x >= p1.getX() - prevDX && x <= p1.getX() + prevDX) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDX = dX;
                    prevDZ = dZ;
                }
                break;
            }
            case Z: {
                if (p2.getZ() == p1.getZ()) break;
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), (double)(p2.getY() - p1.getY()), (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x / lineVec.z, lineVec.y / lineVec.z, lineVec.z);
                double curX = (double)p1.getX() - lineVec.x;
                int z = p1.getZ() + (p2.getZ() > p1.getZ() ? -1 : 1);
                double curY = (double)p1.getY() - lineVec.y;
                int prevDX = -1;
                int prevDY = -1;
                while (z != p2.getZ()) {
                    z += p2.getZ() > p1.getZ() ? 1 : -1;
                    int dX = Math.abs((int)((curX += lineVec.x) - (double)p1.getX()));
                    int dY = Math.abs((int)((curY += lineVec.y) - (double)p1.getY()));
                    if (dX == prevDX) {
                        --prevDX;
                    }
                    if (dY == prevDY) {
                        --prevDY;
                    }
                    for (int x = p1.getX() - dX; x <= p1.getX() + dX; ++x) {
                        for (int y = p1.getY() - dY; y <= p1.getY() + dY; ++y) {
                            if (this.pyramidType != EnumAreaTypePyramid.FILLED && z != p2.getZ() && x >= p1.getX() - prevDX && x <= p1.getX() + prevDX && y >= p1.getY() - prevDY && y <= p1.getY() + prevDY) continue;
                            areaAdder.accept(new BlockPos(x, y, z));
                        }
                    }
                    prevDX = dX;
                    prevDY = dY;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    public AreaTypePyramid() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.pyramidType + "/" + this.axis;
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_PYRAMID: {
                this.axis = AreaType.EnumAxis.X;
                break;
            }
            case Y_PYRAMID: {
                this.axis = AreaType.EnumAxis.Y;
                break;
            }
            case Z_PYRAMID: {
                this.axis = AreaType.EnumAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<AreaType.EnumAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.EnumAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
        widgets.add(new AreaType.AreaTypeWidgetEnum<EnumAreaTypePyramid>("pneumaticcraft.gui.progWidget.area.type.pyramid.pyramidType", EnumAreaTypePyramid.class, () -> this.pyramidType, pyramidType -> {
            this.pyramidType = pyramidType;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putByte("axis", (byte)this.axis.ordinal());
        tag.putByte("pyramidType", (byte)this.pyramidType.ordinal());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.axis = AreaType.EnumAxis.values()[tag.getByte("axis")];
        this.pyramidType = EnumAreaTypePyramid.values()[tag.getByte("pyramidType")];
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.writeEnum((Enum)this.axis);
        buffer.writeEnum((Enum)this.pyramidType);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.axis = (AreaType.EnumAxis)buf.readEnum(AreaType.EnumAxis.class);
        this.pyramidType = (EnumAreaTypePyramid)buf.readEnum(EnumAreaTypePyramid.class);
    }

    private static enum EnumAreaTypePyramid implements ITranslatableEnum
    {
        FILLED("filled"),
        HOLLOW("hollow");

        private final String name;

        private EnumAreaTypePyramid(String name) {
            this.name = "pneumaticcraft.gui.progWidget.area.type.pyramid.pyramidType." + name;
        }

        @Override
        public String getTranslationKey() {
            return this.name;
        }
    }
}

