/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.util.LegacyAreaWidgetConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class AreaTypeWall
extends AreaType {
    public static final String ID = "wall";
    private AreaType.EnumAxis axis = AreaType.EnumAxis.X;

    public AreaTypeWall() {
        super(ID);
    }

    public String toString() {
        return this.getName() + "/" + this.axis;
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                Vec3 lineVec = new Vec3(0.0, (double)(p2.getY() - p1.getY()), (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x, lineVec.y / 10.0, lineVec.z / 10.0);
                double curY = (double)p1.getY() + 0.5;
                double curZ = (double)p1.getZ() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.getY() - p2.getY(), 2.0) + Math.pow(p1.getZ() - p2.getZ(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curY += lineVec.y;
                    curZ += lineVec.z;
                    for (int z = minX; z <= maxX; ++z) {
                        areaAdder.accept(BlockPos.containing((double)z, (double)curY, (double)curZ));
                    }
                }
                break;
            }
            case Y: {
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), 0.0, (double)(p2.getZ() - p1.getZ())).normalize();
                lineVec = new Vec3(lineVec.x, lineVec.y / 10.0, lineVec.z / 10.0);
                double curX = (double)p1.getX() + 0.5;
                double curZ = (double)p1.getZ() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.getX() - p2.getX(), 2.0) + Math.pow(p1.getZ() - p2.getZ(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.x;
                    curZ += lineVec.z;
                    for (int y = minY; y <= maxY; ++y) {
                        areaAdder.accept(BlockPos.containing((double)curX, (double)y, (double)curZ));
                    }
                }
                break;
            }
            case Z: {
                Vec3 lineVec = new Vec3((double)(p2.getX() - p1.getX()), (double)(p2.getY() - p1.getY()), 0.0).normalize();
                lineVec = new Vec3(lineVec.x / 10.0, lineVec.y / 10.0, lineVec.z);
                double curX = (double)p1.getX() + 0.5;
                double curY = (double)p1.getY() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.getX() - p2.getX(), 2.0) + Math.pow(p1.getY() - p2.getY(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.x;
                    curY += lineVec.y;
                    for (int z = minZ; z <= maxZ; ++z) {
                        areaAdder.accept(BlockPos.containing((double)curX, (double)curY, (double)z));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<AreaType.EnumAxis>("pneumaticcraft.gui.progWidget.area.type.general.axis", AreaType.EnumAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putByte("axis", (byte)this.axis.ordinal());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.axis = AreaType.EnumAxis.values()[tag.getByte("axis")];
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buffer) {
        super.writeToPacket(buffer);
        buffer.writeEnum((Enum)this.axis);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.axis = (AreaType.EnumAxis)buf.readEnum(AreaType.EnumAxis.class);
    }

    @Override
    public void convertFromLegacy(LegacyAreaWidgetConverter.EnumOldAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_WALL: {
                this.axis = AreaType.EnumAxis.X;
                break;
            }
            case Y_WALL: {
                this.axis = AreaType.EnumAxis.Y;
                break;
            }
            case Z_WALL: {
                this.axis = AreaType.EnumAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

