/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity;

import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RingEntity
extends Entity {
    public ProgressingLine ring;
    public ProgressingLine oldRing;
    private final Entity targetEntity;
    public final int color;

    public RingEntity(EntityType<RingEntity> type, Level world) {
        super(type, world);
        this.targetEntity = null;
        this.color = 0;
    }

    public RingEntity(Level par1World, double startX, double startY, double startZ, Entity targetEntity, int color) {
        super(ModEntityTypes.RING.get(), par1World);
        this.setPos(startX, startY, startZ);
        this.xOld = startX;
        this.yOld = startY;
        this.zOld = startZ;
        this.targetEntity = targetEntity;
        this.color = color;
        double dx = targetEntity.getX() - this.getX();
        double dy = targetEntity.getY() - this.getY();
        double dz = targetEntity.getZ() - this.getZ();
        float f = Mth.sqrt((float)((float)(dx * dx + dz * dz)));
        this.setYRot((float)(Math.atan2(dx, dz) * 180.0 / Math.PI));
        this.setXRot((float)(Math.atan2(dy, f) * 180.0 / Math.PI));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        this.noCulling = true;
        if (par1World.isClientSide) {
            RingEntity.setViewScale((double)10.0);
        }
    }

    public void tick() {
        if (this.targetEntity == null) {
            return;
        }
        Vec3 end = this.targetEntity.position();
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        if (this.ring == null) {
            this.ring = new ProgressingLine(this.position(), end);
        } else {
            if (this.oldRing == null) {
                this.oldRing = new ProgressingLine(this.ring.startX, this.ring.startY, this.ring.startZ, this.ring.endX, this.ring.endY, this.ring.endZ);
            } else {
                this.oldRing.endX = this.ring.endX;
                this.oldRing.endY = this.ring.endY;
                this.oldRing.endZ = this.ring.endZ;
            }
            this.ring.endX = (float)end.x;
            this.ring.endY = (float)end.y;
            this.ring.endZ = (float)end.z;
            double dx = end.x - this.getX();
            double dy = end.y - this.getY();
            double dz = end.z - this.getZ();
            double f = Math.sqrt(dx * dx + dz * dz);
            this.setYRot((float)(Math.atan2(dx, dz) * 180.0 / Math.PI));
            this.setXRot((float)(Math.atan2(dy, f) * 180.0 / Math.PI));
            this.oldRing.setProgress(this.ring.getProgress());
            if (this.ring.incProgress(0.05f)) {
                this.discard();
            }
        }
    }

    protected void defineSynchedData() {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }
}

