/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.drone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetPickupItem;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetWait;
import me.desht.pneumaticcraft.common.entity.drone.AbstractBasicDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.DroneProgramBuilder;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class CollectorDroneEntity
extends AbstractBasicDroneEntity {
    public CollectorDroneEntity(EntityType<? extends DroneEntity> type, Level world) {
        super(type, world);
    }

    public CollectorDroneEntity(Level world, Player player) {
        super(ModEntityTypes.COLLECTOR_DRONE.get(), world, player);
    }

    @Override
    public boolean addProgram(BlockPos clickPos, Direction facing, BlockPos pos, ItemStack droneStack, List<IProgWidget> widgets) {
        DroneProgramBuilder builder = new DroneProgramBuilder();
        builder.add(new ProgWidgetStart(), new IProgWidget[0]);
        BlockPos invPos = clickPos;
        ArrayList<ProgWidgetArea> params = new ArrayList<ProgWidgetArea>();
        int rangeUpgrades = UpgradableItemUtils.getUpgradeCount(droneStack, ModUpgrades.RANGE.get());
        params.add(ProgWidgetArea.fromPosition(pos, 16 + rangeUpgrades * 2));
        Optional<IItemHandler> itemCap = IOHelper.getInventoryForBlock(this.level().getBlockEntity(clickPos), facing);
        if (itemCap.isPresent()) {
            Set<Item> filtered = this.getFilteredItems(itemCap.get());
            if (!filtered.isEmpty()) {
                filtered.forEach(item -> params.add((ProgWidgetArea)((Object)ProgWidgetItemFilter.withFilter(new ItemStack((ItemLike)item)))));
            }
        } else {
            invPos = this.findAdjacentInventory(pos);
        }
        builder.add(new ProgWidgetPickupItem(), params.toArray(new IProgWidget[0]));
        ProgWidgetInventoryExport export = new ProgWidgetInventoryExport();
        boolean[] sides = new boolean[6];
        sides[facing.get3DDataValue()] = true;
        export.setSides(sides);
        builder.add(export, ProgWidgetArea.fromPosition(invPos));
        this.maybeAddStandbyInstruction(builder, droneStack);
        builder.add(new ProgWidgetWait(), ProgWidgetText.withText("2s"));
        widgets.addAll(builder.build());
        return true;
    }

    private BlockPos findAdjacentInventory(BlockPos pos) {
        return Arrays.stream(Direction.values()).filter(d -> IOHelper.getInventoryForBlock(this.level().getBlockEntity(pos.relative(d)), d.getOpposite()).isPresent()).findFirst().map(arg_0 -> ((BlockPos)pos).relative(arg_0)).orElse(pos);
    }

    private Set<Item> getFilteredItems(IItemHandler handler) {
        return IntStream.range(0, handler.getSlots()).filter(i -> !handler.getStackInSlot(i).isEmpty()).mapToObj(i -> handler.getStackInSlot(i).getItem()).collect(Collectors.toSet());
    }
}

