/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.registry.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.EventHooks;
import org.apache.commons.lang3.Validate;
import org.joml.Vector3f;

public class TumblingBlockEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<BlockPos> ORIGIN = SynchedEntityData.defineId(TumblingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<ItemStack> STATE_STACK = SynchedEntityData.defineId(TumblingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final GameProfile DEFAULT_FAKE_PROFILE = UUIDUtil.createOfflineProfile((String)"Tumbling Block");
    private static final Vec3 Y_POS = new Vec3(0.0, 1.0, 0.0);
    public final Vector3f tumbleVec;

    public TumblingBlockEntity(EntityType<TumblingBlockEntity> type, Level worldIn) {
        super(type, worldIn);
        this.tumbleVec = this.makeTumbleVec(worldIn, null);
    }

    public TumblingBlockEntity(Level worldIn, LivingEntity thrower, double x, double y, double z, @Nonnull ItemStack stack) {
        super(ModEntityTypes.TUMBLING_BLOCK.get(), worldIn);
        Validate.isTrue((!stack.isEmpty() && stack.getItem() instanceof BlockItem ? 1 : 0) != 0);
        this.setOwner((Entity)thrower);
        this.blocksBuilding = true;
        this.setPos(x, y + (double)((1.0f - this.getBbHeight()) / 2.0f), z);
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.tumbleVec = this.makeTumbleVec(worldIn, thrower);
        this.setOrigin(this.blockPosition());
        this.entityData.set(STATE_STACK, (Object)stack);
    }

    private Vector3f makeTumbleVec(Level world, LivingEntity thrower) {
        if (thrower != null) {
            return thrower.getLookAngle().cross(Y_POS).toVector3f();
        }
        if (world != null && world.isClientSide) {
            return ClientUtils.getOptionalClientPlayer().map(p -> p.getLookAngle().cross(Y_POS).toVector3f()).orElse(null);
        }
        return null;
    }

    protected void defineSynchedData() {
        this.entityData.define(ORIGIN, (Object)BlockPos.ZERO);
        this.entityData.define(STATE_STACK, (Object)ItemStack.EMPTY);
    }

    public void shootFromRotation(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
    }

    public ItemStack getStack() {
        return (ItemStack)this.entityData.get(STATE_STACK);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.entityData.get(ORIGIN);
    }

    private void setOrigin(BlockPos pos) {
        this.entityData.set(ORIGIN, (Object)pos);
    }

    public void tick() {
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        super.tick();
        if (!this.level().isClientSide) {
            BlockPos blockpos1 = this.blockPosition();
            if (!(this.onGround() || (this.tickCount <= 100 || blockpos1.getY() >= 1 && blockpos1.getY() <= 256) && this.tickCount <= 600)) {
                this.dropAsItem();
                this.discard();
            }
        }
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            this.discard();
            if (result.getType() == HitResult.Type.BLOCK) {
                if (!this.tryPlaceAsBlock((BlockHitResult)result)) {
                    this.dropAsItem();
                }
            } else {
                this.dropAsItem();
            }
        }
    }

    private boolean tryPlaceAsBlock(BlockHitResult brtr) {
        BlockSnapshot snapshot;
        BlockPos pos;
        Player p;
        ItemStack stack = this.getStack();
        if (!(stack.getItem() instanceof BlockItem)) {
            return false;
        }
        BlockPos pos0 = brtr.getBlockPos();
        Direction face = brtr.getDirection();
        Entity entity = this.getOwner();
        Player placer = entity instanceof Player ? (p = (Player)entity) : this.getFakePlayer();
        BlockState state = this.level().getBlockState(pos0);
        LocalBlockPlaceContext ctx = new LocalBlockPlaceContext(new UseOnContext(placer, InteractionHand.MAIN_HAND, brtr));
        BlockPos blockPos = pos = state.canBeReplaced((BlockPlaceContext)ctx) ? pos0 : pos0.relative(face);
        if (this.level().getBlockState(pos).canBeReplaced((BlockPlaceContext)ctx) && !EventHooks.onBlockPlace((Entity)placer, (BlockSnapshot)(snapshot = BlockSnapshot.create((ResourceKey)this.level().dimension(), (LevelAccessor)this.level(), (BlockPos)pos)), (Direction)face)) {
            InteractionResult res = ((BlockItem)stack.getItem()).place((BlockPlaceContext)ctx);
            return res == InteractionResult.SUCCESS || res == InteractionResult.CONSUME;
        }
        return false;
    }

    private void dropAsItem() {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            this.spawnAtLocation(this.getStack().copy(), 0.0f);
        }
    }

    private Player getFakePlayer() {
        FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.level()), (GameProfile)DEFAULT_FAKE_PROFILE);
        fakePlayer.setPos(this.getX(), this.getY(), this.getZ());
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, this.getStack());
        return fakePlayer;
    }

    private static class LocalBlockPlaceContext
    extends BlockPlaceContext {
        private final ItemStack stack;

        public LocalBlockPlaceContext(UseOnContext context) {
            super(context);
            this.stack = context.getItemInHand().copy();
        }

        public ItemStack getItemInHand() {
            return this.stack == null ? ItemStack.EMPTY : this.stack;
        }
    }
}

