/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.IPlantable;

public class VortexEntity
extends ThrowableProjectile {
    private int hitCounter = 0;
    private float renderOffsetX = -3.4028235E38f;
    private static int lastPlayerBoost;

    public VortexEntity(EntityType<? extends VortexEntity> type, Level world) {
        super(type, world);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            BlockPos.betweenClosedStream((AABB)this.getBoundingBox()).filter(pos -> this.vortexBreakable(this.level().getBlockState(pos).getBlock())).forEach(this::handleVortexCollision);
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
        if (this.getDeltaMovement().lengthSqr() < 0.1) {
            this.discard();
        }
    }

    public boolean hasRenderOffsetX() {
        return this.renderOffsetX > -3.4028235E38f;
    }

    public float getRenderOffsetX() {
        return this.renderOffsetX;
    }

    public void setRenderOffsetX(float renderOffsetX) {
        this.renderOffsetX = renderOffsetX;
    }

    public float getGravity() {
        return 0.0f;
    }

    protected void onHit(HitResult rtr) {
        if (rtr.getType() == HitResult.Type.ENTITY) {
            Player player;
            Entity entity = ((EntityHitResult)rtr).getEntity();
            if (entity instanceof Player && (!(player = (Player)entity).level().isClientSide() || this.boostedRecently(player))) {
                return;
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(this.getDeltaMovement().add(0.0, 0.4, 0.0)));
            ItemStack shears = new ItemStack((ItemLike)Items.SHEARS);
            if (entity instanceof LivingEntity) {
                Player shooter;
                Player player2 = shooter = this.getOwner() instanceof Player ? (Player)this.getOwner() : null;
                if (shooter != null) {
                    shears.getItem().interactLivingEntity(shears, shooter, (LivingEntity)entity, InteractionHand.MAIN_HAND);
                }
            }
        } else if (rtr.getType() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)rtr).getBlockPos();
            Block block = this.level().getBlockState(pos).getBlock();
            if (this.vortexBreakable(block)) {
                if (!this.level().isClientSide) {
                    this.handleVortexCollision(pos);
                }
            } else {
                this.discard();
            }
        }
        ++this.hitCounter;
        if (this.hitCounter > 20) {
            this.discard();
        }
    }

    private boolean boostedRecently(Player player) {
        if (player.tickCount - lastPlayerBoost < 20) {
            return true;
        }
        lastPlayerBoost = player.tickCount;
        return false;
    }

    private void handleVortexCollision(BlockPos pos) {
        this.level().destroyBlock(pos, true);
        this.setDeltaMovement(this.getDeltaMovement().scale(0.85));
    }

    private boolean vortexBreakable(Block block) {
        return block instanceof IPlantable || block instanceof LeavesBlock || block instanceof WebBlock || block instanceof SnowLayerBlock;
    }

    protected void defineSynchedData() {
    }
}

