/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.entity.semiblock;

import java.util.Locale;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TransferGadgetEntity
extends AbstractSemiblockEntity
implements IDirectionalSemiblock {
    private static final int TRANSFER_INTERVAL = 40;
    private static final double INDENT = 0.0625;
    private static final double THICKNESS = 0.03125;
    private static final double ANTI_Z_FIGHT = 0.001;
    private static final EntityDataAccessor<Integer> IO_MODE = SynchedEntityData.defineId(TransferGadgetEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SIDE = SynchedEntityData.defineId(TransferGadgetEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int counter;

    public TransferGadgetEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.getEntityData().define(IO_MODE, (Object)IOMode.OUTPUT.ordinal());
        this.getEntityData().define(SIDE, (Object)Direction.UP.get3DDataValue());
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isAlive() && ++this.counter >= 40) {
            this.counter = 0;
            this.doTransfer();
        }
    }

    @Override
    public void onPlaced(Player player, ItemStack stack, Direction facing) {
        super.onPlaced(player, stack, facing);
        this.setIOMode(IOMode.OUTPUT);
        this.setSide(facing);
    }

    @Override
    public boolean onRightClickWithConfigurator(Player player, Direction side) {
        if (this.getSide() == side) {
            this.toggle(player);
            return true;
        }
        return super.onRightClickWithConfigurator(player, side);
    }

    @Override
    public InteractionResult interactAt(Player player, Vec3 hitVec, InteractionHand hand) {
        if (player.getItemInHand(hand).isEmpty()) {
            this.toggle(player);
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(player, hitVec, hand);
    }

    private void toggle(Player player) {
        this.setIOMode(this.getIOMode().toggle());
        player.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 1.0f);
    }

    @Override
    public boolean canStay() {
        return this.canPlace(this.getSide());
    }

    @Override
    public boolean canPlace(Direction facing) {
        BlockEntity te = this.getCachedTileEntity();
        return te != null && (IOHelper.getInventoryForBlock(te, facing).isPresent() || IOHelper.getFluidHandlerForBlock(te, facing).isPresent());
    }

    @Override
    public Direction getSide() {
        return Direction.values()[(Integer)this.getEntityData().get(SIDE)];
    }

    @Override
    public void setSide(Direction facing) {
        this.getEntityData().set(SIDE, (Object)facing.get3DDataValue());
    }

    public IOMode getIOMode() {
        return IOMode.values()[(Integer)this.getEntityData().get(IO_MODE)];
    }

    private void setIOMode(IOMode mode) {
        this.getEntityData().set(IO_MODE, (Object)mode.ordinal());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.counter = compound.getInt("counter");
        this.setSide(Direction.from3DDataValue((int)compound.getByte("facing")));
        this.setIOMode(compound.getBoolean("input") ? IOMode.INPUT : IOMode.OUTPUT);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("counter", this.counter);
        compound.putByte("facing", (byte)this.getSide().get3DDataValue());
        compound.putBoolean("input", this.getIOMode() == IOMode.INPUT);
    }

    @Override
    public void addTooltip(Consumer<Component> curInfo, Player player, CompoundTag tag, boolean extended) {
        curInfo.accept((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.facing", this.getSide()));
        curInfo.accept((Component)PneumaticCraftUtils.xlate(this.getIOMode().getTranslationKey(), new Object[0]));
    }

    @Override
    protected AABB calculateBlockBounds() {
        AABB b = super.calculateBlockBounds();
        return switch (this.getSide()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> new AABB(b.minX - 0.03125, b.maxY - 0.0625, b.minZ - 0.03125, b.maxX + 0.03125, b.maxY + 0.03125, b.maxZ + 0.03125);
            case Direction.DOWN -> new AABB(b.minX - 0.03125, -0.001, b.minZ - 0.03125, b.maxX + 0.03125, b.minY + 0.0625, b.maxZ + 0.03125);
            case Direction.NORTH -> new AABB(b.minX - 0.03125, b.minY - 0.03125, -0.001, b.maxX + 0.03125, b.maxY + 0.03125, b.minZ + 0.0625);
            case Direction.SOUTH -> new AABB(b.minX - 0.03125, b.minY - 0.03125, b.maxZ - 0.0625, b.maxX + 0.03125, b.maxY + 0.03125, 1.001);
            case Direction.WEST -> new AABB(-0.001, b.minY - 0.03125, b.minZ - 0.03125, b.minX + 0.0625, b.maxY + 0.03125, b.maxZ + 0.03125);
            case Direction.EAST -> new AABB(b.maxX - 0.0625, b.minY - 0.03125, b.minZ - 0.03125, 1.001, b.maxY + 0.03125, b.maxZ + 0.03125);
        };
    }

    private void doTransfer() {
        BlockEntity inputTE = this.getCachedTileEntity();
        Direction side = this.getSide();
        Direction otherSide = this.getSide().getOpposite();
        BlockEntity outputTE = this.level().getBlockEntity(this.getBlockPos().relative(side));
        if (inputTE != null && outputTE != null) {
            if (this.getIOMode() == IOMode.OUTPUT) {
                this.tryTransferItem(inputTE, outputTE, side, otherSide);
                this.tryTransferFluid(inputTE, outputTE, side, otherSide);
            } else {
                this.tryTransferItem(outputTE, inputTE, otherSide, side);
                this.tryTransferFluid(outputTE, inputTE, otherSide, side);
            }
        }
    }

    private void tryTransferItem(BlockEntity inputTE, BlockEntity outputTE, Direction side, Direction otherSide) {
        IOHelper.getInventoryForBlock(inputTE, side).ifPresent(input -> IOHelper.getInventoryForBlock(outputTE, otherSide).ifPresent(output -> IOHelper.transferOneItem(input, output)));
    }

    private void tryTransferFluid(BlockEntity inputTE, BlockEntity outputTE, Direction side, Direction otherSide) {
        IOHelper.getFluidHandlerForBlock(inputTE, side).ifPresent(input -> IOHelper.getFluidHandlerForBlock(outputTE, otherSide).ifPresent(output -> FluidUtil.tryFluidTransfer((IFluidHandler)output, (IFluidHandler)input, (int)100, (boolean)true)));
    }

    public static enum IOMode implements ITranslatableEnum
    {
        INPUT(Textures.MODEL_TRANSFER_GADGET_IN),
        OUTPUT(Textures.MODEL_TRANSFER_GADGET_OUT);

        private final ResourceLocation texture;

        private IOMode(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        IOMode toggle() {
            return this == INPUT ? OUTPUT : INPUT;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.transfer_gadget.io_mode." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

