/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.InventoryTrackEvent;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.DroneClaimManager;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.SpawnerAgitatorEntity;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketModWrenchBlock;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.common.recipes.machine.ExplosionCraftingRecipeImpl;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.tubemodules.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.FillBucketEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class MiscEventHandler {
    private static final Set<ResourceLocation> needsTPSSync = new HashSet<ResourceLocation>();

    public static void needsTPSSync(Level level) {
        if (level != null && (level.getGameTime() & 0x3FL) == 0L) {
            needsTPSSync.add(level.dimension().location());
        }
    }

    @SubscribeEvent
    public void onWorldTickEnd(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.level.isClientSide) {
            DroneClaimManager.getInstance(event.level).tick();
            if ((event.level.getGameTime() & 0x7FL) == 0L && needsTPSSync.contains(event.level.dimension().location())) {
                double tickTime = (double)event.level.getServer().getAverageTickTimeNanos() / 1000000.0;
                NetworkHandler.sendToDimension(new PacketServerTickTime(tickTime), (ResourceKey<Level>)event.level.dimension());
                needsTPSSync.remove(event.level.dimension().location());
            }
        }
    }

    @SubscribeEvent
    public void handleFuelEvent(FurnaceFuelBurnTimeEvent event) {
        ItemStack containerStack = event.getItemStack();
        if (containerStack.hasCraftingRemainingItem()) {
            FluidUtil.getFluidContained((ItemStack)containerStack).ifPresent(fluidStack -> PneumaticCraftUtils.getRegistryName(fluidStack.getFluid()).ifPresent(regName -> {
                if ("pneumaticcraft".equals(regName.getNamespace())) {
                    int value = PneumaticRegistry.getInstance().getFuelRegistry().getFuelValue(null, fluidStack.getFluid());
                    if (value > 0) {
                        int amountTaken = this.amountTaken(fluidStack.getAmount(), containerStack);
                        double mult = (double)Math.min(amountTaken, fluidStack.getAmount()) / 1000.0;
                        event.setBurnTime((int)((double)value * mult * (Double)ConfigHelper.common().general.fuelBucketEfficiency.get()));
                    } else {
                        event.setBurnTime(-1);
                    }
                }
            }));
        }
    }

    private int amountTaken(int origAmount, ItemStack stack) {
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCraftingRemainingItem().getCapability(Capabilities.FluidHandler.ITEM);
        if (handler != null) {
            int newAmount = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount();
            return origAmount - newAmount;
        }
        return origAmount;
    }

    @SubscribeEvent
    public void explosionCraftingEvent(ExplosionEvent.Detonate event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        Iterator iterator = event.getAffectedEntities().iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            Entity entity = (Entity)iterator.next();
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.isAlive() || (stack = itemEntity.getItem()).isEmpty()) continue;
            boolean firstItem = true;
            for (ItemStack result : ExplosionCraftingRecipeImpl.tryToCraft(event.getLevel(), stack)) {
                if (firstItem) {
                    itemEntity.setItem(result);
                    iterator.remove();
                    firstItem = false;
                    continue;
                }
                PneumaticCraftUtils.dropItemOnGround(result, event.getLevel(), entity.blockPosition());
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        Entity entity = event.getEntity();
        if (entity instanceof IDroneBase) {
            IDroneBase d = (IDroneBase)entity;
            NeoForge.EVENT_BUS.post((Event)new DroneConstructingEvent(d));
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        HitResult hitResult = event.getTarget();
        if (hitResult instanceof BlockHitResult) {
            LiquidBlock l;
            BlockHitResult brtr = (BlockHitResult)hitResult;
            hitResult = event.getLevel().getBlockState(brtr.getBlockPos()).getBlock();
            if (hitResult instanceof LiquidBlock && (l = (LiquidBlock)hitResult).getFluid().is(PneumaticCraftTags.Fluids.CRUDE_OIL) && (hitResult = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)hitResult;
                ModCriterionTriggers.OIL_BUCKET.get().trigger(sp);
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (!event.isCanceled() && state.getBlock() instanceof IPneumaticWrenchable) {
            if (event.getHand() == InteractionHand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntity().getItemInHand(InteractionHand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntity().getItemInHand(event.getHand()))) {
                if (event.getLevel().isClientSide) {
                    NetworkHandler.sendToServer(PacketModWrenchBlock.forSide(event.getPos(), event.getHand(), event.getFace()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onModdedWrenchEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled() && event.getTarget() instanceof IPneumaticWrenchable) {
            if (event.getHand() == InteractionHand.OFF_HAND && ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntity().getItemInHand(InteractionHand.MAIN_HAND))) {
                event.setCanceled(true);
            } else if (ModdedWrenchUtils.getInstance().isModdedWrench(event.getEntity().getItemInHand(event.getHand()))) {
                if (event.getLevel().isClientSide) {
                    NetworkHandler.sendToServer(PacketModWrenchBlock.forEntity(event.getPos(), event.getHand(), event.getTarget().getId()));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void quetziMoo(ServerChatEvent event) {
        String username = event.getUsername();
        ServerPlayer player = event.getPlayer();
        if (username.equals("Quetzz") && event.getMessage().getString().equals("m00")) {
            for (int i = 0; i < 4; ++i) {
                NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.COW_AMBIENT, SoundSource.NEUTRAL, (float)player.getX(), (float)player.getY(), (float)player.getZ(), 1.0f, 1.0f, true), player);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level world = (Level)levelAccessor;
            if (!world.isClientSide) {
                ModuleNetworkManager.getInstance(world).invalidateCache();
            }
        }
    }

    @SubscribeEvent
    public void onInventoryTracking(InventoryTrackEvent event) {
        if (event.getTileEntity() instanceof ProgrammerBlockEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getSlot().getType() == EquipmentSlot.Type.HAND && event.getTo().getItem() instanceof IPositionProvider) {
                ((IPositionProvider)event.getTo().getItem()).syncVariables(player, event.getTo());
            } else if (event.getSlot() == EquipmentSlot.MAINHAND) {
                if (event.getTo().getItem() instanceof MinigunItem) {
                    ((MinigunItem)event.getTo().getItem()).onEquipmentChange(player, event.getTo(), true);
                } else if (event.getFrom().getItem() instanceof MinigunItem) {
                    ((MinigunItem)event.getFrom().getItem()).onEquipmentChange(player, event.getFrom(), false);
                }
            } else if (event.getSlot().getType() == EquipmentSlot.Type.ARMOR) {
                for (ItemStack stack : player.getArmorSlots()) {
                    if (stack.getItem() instanceof PneumaticArmorItem) continue;
                    return;
                }
                ModCriterionTriggers.PNEUMATIC_ARMOR.get().trigger(player);
            }
        }
    }

    @SubscribeEvent
    public void entityMounting(EntityMountEvent event) {
        if (event.isMounting() && event.getEntityMounting() instanceof DroneEntity && (event.getEntityBeingMounted() instanceof AbstractMinecart || event.getEntityBeingMounted() instanceof Boat) && !event.getEntityBeingMounted().onGround()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTagsUpdated(TagsUpdatedEvent event) {
        CommonArmorRegistry.getInstance().resolveBlockTags();
        PneumaticRegistry.getInstance().getMiscHelpers().registerXPFluid(FluidIngredient.of(1, PneumaticCraftTags.Fluids.EXPERIENCE), 20);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getSpawner() != null) {
            event.getEntity().addTag("pneumaticcraft:defender");
            ServerLevelAccessor serverLevelAccessor = event.getLevel();
            if (serverLevelAccessor instanceof Level) {
                ISemiBlock semi;
                Level level = (Level)serverLevelAccessor;
                BlockEntity be = event.getSpawner().getSpawnerBlockEntity();
                if (be != null && (semi = SemiblockTracker.getInstance().getSemiblock(level, be.getBlockPos())) instanceof SpawnerAgitatorEntity) {
                    event.getEntity().setPersistenceRequired();
                }
            }
        }
    }
}

