/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.living.LivingAttackEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class PneumaticArmorHandler {
    private static final Int2IntMap targetingTracker = new Int2IntOpenHashMap();
    private static final Map<UUID, Map<String, Integer>> targetWarnings = new HashMap<UUID, Map<String, Integer>>();
    private static final int ARMOR_REPAIR_AMOUNT = 16;

    @SubscribeEvent
    public void onMobTargetSet(LivingChangeTargetEvent event) {
        int mobId = event.getEntity().getId();
        LivingEntity livingEntity = event.getNewTarget();
        if (livingEntity instanceof ServerPlayer) {
            CommonArmorHandler handler;
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (PneumaticArmorItem.isPneumaticArmorPiece((Player)player, EquipmentSlot.HEAD) && (!targetingTracker.containsKey(mobId) || targetingTracker.get(mobId) != event.getNewTarget().getId()) && (handler = CommonArmorHandler.getHandlerForPlayer((Player)player)).upgradeUsable(CommonUpgradeHandlers.entityTrackerHandler, true)) {
                Map map = targetWarnings.computeIfAbsent(player.getUUID(), k -> new HashMap());
                map.merge(event.getEntity().getName().getString(), 1, Integer::sum);
            }
            targetingTracker.put(mobId, event.getNewTarget().getId());
        } else {
            targetingTracker.remove(mobId);
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        targetingTracker.remove(event.getEntity().getId());
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        CommonArmorHandler handler;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && PneumaticArmorItem.isPneumaticArmorPiece(player = (Player)livingEntity, EquipmentSlot.CHEST) && event.getSource().is(DamageTypeTags.IS_FIRE) && !player.isCreative() && !player.isSpectator() && (handler = CommonArmorHandler.getHandlerForPlayer(player)).isArmorEnabled() && handler.hasMinPressure(EquipmentSlot.CHEST) && handler.getUpgradeCount(EquipmentSlot.CHEST, ModUpgrades.SECURITY.get()) > 0) {
            event.setCanceled(true);
            player.clearFire();
            if (!player.level().isClientSide) {
                handler.addAir(EquipmentSlot.CHEST, -50);
                for (int i = 0; i < 2; ++i) {
                    float sx = player.getRandom().nextFloat() * 1.5f - 0.75f;
                    float sz = player.getRandom().nextFloat() * 1.5f - 0.75f;
                    NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, player.getX() + (double)sx, player.getY() + 1.0, player.getZ() + (double)sz, sx / 4.0f, -0.2, sz / 4.0f), player.level(), player.blockPosition());
                }
                if ((player.tickCount & 0xF) == 0) {
                    player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.LEAKING_GAS.get(), SoundSource.PLAYERS, 1.0f, 0.7f);
                    this.tryExtinguish(player);
                }
            }
        }
    }

    private void tryExtinguish(Player player) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos pos = player.blockPosition().offset(i, 0, j);
                BlockState state = player.level().getBlockState(pos);
                if (state.getBlock() == Blocks.FIRE && player.getRandom().nextInt(3) == 0) {
                    player.level().removeBlock(pos, false);
                    continue;
                }
                if (state.getBlock() != Blocks.LAVA || player.getRandom().nextInt(5) != 0) continue;
                int level = (Integer)state.getValue((Property)LiquidBlock.LEVEL);
                player.level().setBlockAndUpdate(pos, level == 0 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = player.getItemBySlot(EquipmentSlot.LEGS);
            if (!(stack.getItem() instanceof PneumaticArmorItem)) {
                return;
            }
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            if (handler.upgradeUsable(CommonUpgradeHandlers.jetBootsHandler, true) && !handler.getExtensionData(CommonUpgradeHandlers.jetBootsHandler).isSmartHover()) {
                return;
            }
            if (handler.upgradeUsable(CommonUpgradeHandlers.jumpBoostHandler, true)) {
                float power = (float)PneumaticArmorItem.getIntData(stack, "jumpBoost", 100, 0, 100) / 100.0f;
                int rangeUpgrades = handler.getUpgradeCount(EquipmentSlot.LEGS, ModUpgrades.JUMPING.get(), player.isShiftKeyDown() ? 1 : 4);
                float actualBoost = Math.max(1.0f, (float)rangeUpgrades * power);
                Vec3 m = player.getDeltaMovement();
                double scale = player.isSprinting() ? (double)actualBoost : (double)actualBoost * 0.6;
                player.setDeltaMovement(m.x * scale, m.y + (double)(actualBoost * 0.15f), m.z * scale);
                int airUsed = (int)Math.ceil(25.0f * actualBoost * (float)(player.isSprinting() ? 2 : 1));
                handler.addAir(EquipmentSlot.LEGS, -airUsed);
            }
        }
    }

    @SubscribeEvent
    public void breakSpeedCheck(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        int max = 5;
        if (PneumaticArmorItem.isPneumaticArmorPiece(player, EquipmentSlot.FEET) && !player.onGround()) {
            int n;
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(event.getEntity());
            JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState(player);
            if (jbState.isEnabled() && jbState.isBuilderMode() && (n = max + 1 - handler.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.JET_BOOTS.get(), max)) < 4) {
                float newSpeed;
                float mult = 5.0f / (float)n;
                float oldSpeed = event.getOriginalSpeed();
                if (oldSpeed < (newSpeed = event.getNewSpeed()) * mult) {
                    event.setNewSpeed(newSpeed * mult);
                }
            }
        }
    }

    @SubscribeEvent
    public void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        CommonArmorHandler handler;
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && PneumaticArmorItem.isPneumaticArmorPiece(player = (Player)entity, EquipmentSlot.FEET) && (handler = CommonArmorHandler.getHandlerForPlayer(player)).hasMinPressure(EquipmentSlot.FEET) && handler.isArmorReady(EquipmentSlot.FEET)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (event.player.level().isClientSide) {
            this.handleJetbootsPose(event.player);
        } else if (event.player instanceof ServerPlayer && event.player.level().getGameTime() % 20L == 0L && PneumaticArmorItem.isPneumaticArmorPiece(event.player, EquipmentSlot.HEAD)) {
            this.handleTargetWarnings((ServerPlayer)event.player);
        }
    }

    private void handleJetbootsPose(Player thisPlayer) {
        JetBootsStateTracker tracker = JetBootsStateTracker.getClientTracker();
        int distThresholdSq = ClientUtils.getRenderDistanceThresholdSq();
        for (Player otherPlayer : thisPlayer.level().players()) {
            JetBootsStateTracker.JetBootsState state;
            if (otherPlayer.onGround() || !PneumaticArmorItem.isPneumaticArmorPiece(otherPlayer, EquipmentSlot.FEET) || (state = tracker.getJetBootsState(otherPlayer)) == null || !state.isEnabled() || otherPlayer.isFallFlying() && !state.isActive() || !(otherPlayer.distanceToSqr((Entity)thisPlayer) < (double)distThresholdSq) || otherPlayer.getId() == thisPlayer.getId() || !state.shouldRotatePlayer()) continue;
            otherPlayer.setPose(Pose.FALL_FLYING);
        }
    }

    private void handleTargetWarnings(ServerPlayer player) {
        Map<String, Integer> map = targetWarnings.get(player.getUUID());
        if (map != null) {
            map.forEach((name, count) -> {
                MutableComponent msg = PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.targetWarning", name);
                if (count > 1) {
                    msg.append(" (x" + count + ")");
                }
                NetworkHandler.sendToPlayer(new PacketSendArmorHUDMessage((Component)msg, 60, 1895776256), player);
            });
            map.clear();
        }
    }

    @SubscribeEvent
    public void onArmorRepair(AnvilUpdateEvent event) {
        if (event.getLeft().getItem() instanceof PneumaticArmorItem && new ItemStack((ItemLike)event.getLeft().getItem()).is(PneumaticCraftTags.Items.INGOTS_COMPRESSED_IRON)) {
            ItemStack repairedItem = event.getLeft().copy();
            int damageRepaired = Math.min(repairedItem.getDamageValue(), event.getRight().getCount() * 16);
            int ingotsToUse = (damageRepaired - 1) / 16 + 1;
            repairedItem.setDamageValue(repairedItem.getDamageValue() - damageRepaired);
            event.setOutput(repairedItem);
            event.setCost(Math.max(1, ingotsToUse / 2));
            event.setMaterialCost(ingotsToUse);
        }
    }

    @SubscribeEvent
    public void onPlayerTrack(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            CommonArmorHandler handler;
            ServerPlayer trackedPlayer;
            ServerPlayer sp = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof ServerPlayer && (trackedPlayer = (ServerPlayer)player).getItemBySlot(EquipmentSlot.FEET).getItem() == ModItems.PNEUMATIC_BOOTS.get() && (handler = CommonArmorHandler.getHandlerForPlayer((Player)trackedPlayer)).getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.JET_BOOTS.get()) > 0) {
                JetBootsStateTracker.JetBootsState state = JetBootsStateTracker.getServerTracker().getJetBootsState((Player)trackedPlayer);
                NetworkHandler.sendToPlayer(new PacketJetBootsStateSync(trackedPlayer.getUUID(), state), sp);
            }
        }
    }
}

