/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.event;

import me.desht.pneumaticcraft.common.block.entity.utility.UniversalSensorBlockEntity;
import me.desht.pneumaticcraft.common.util.GlobalBlockEntityCacheManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.EntityItemPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class UniversalSensorHandler {
    @SubscribeEvent
    public void onInteraction(PlayerInteractEvent.RightClickBlock event) {
        this.sendEventToSensors(event.getEntity().level(), (Event)event);
    }

    @SubscribeEvent
    public void onInteraction(PlayerInteractEvent.RightClickItem event) {
        this.sendEventToSensors(event.getEntity().level(), (Event)event);
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        this.sendEventToSensors(event.getEntity().level(), (Event)event);
    }

    @SubscribeEvent
    public void onItemPickUp(EntityItemPickupEvent event) {
        this.sendEventToSensors(event.getEntity().level(), (Event)event);
    }

    private void sendEventToSensors(Level level, Event event) {
        if (!level.isClientSide) {
            for (UniversalSensorBlockEntity sensor : GlobalBlockEntityCacheManager.getInstance((LevelAccessor)level).getUniversalSensors()) {
                sensor.onEvent(event);
            }
        }
    }
}

