/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking;

import java.util.List;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.hacking.HackTickTracker;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncEntityHacks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public enum HackEventListener {
    INSTANCE;


    public static HackEventListener getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void worldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HackTickTracker.getInstance(event.level).tick(event.level);
        }
    }

    @SubscribeEvent
    public void onEntityJoining(EntityJoinLevelEvent event) {
        HackManager.getActiveHacks(event.getEntity()).ifPresent(hacking -> hacking.getCurrentHacks().forEach(hack -> HackTickTracker.getInstance(event.getLevel()).trackEntity(event.getEntity(), (IHackableEntity<?>)hack)));
    }

    @SubscribeEvent
    public void onEntityTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            HackManager.getActiveHacks((Entity)event.getEntity()).ifPresent(hacking -> {
                List<ResourceLocation> ids = hacking.getCurrentHacks().stream().map(IHackableEntity::getHackableId).toList();
                if (!ids.isEmpty()) {
                    NetworkHandler.sendToPlayer(PacketSyncEntityHacks.create(event.getTarget(), ids), sp);
                }
            });
        }
    }
}

