/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableBlock;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class HackTickTracker
extends SavedData {
    private static final String DATA_NAME = "PneumaticCraftBlockHacks";
    private static final HackTickTracker clientInstance = new HackTickTracker();
    private final Map<BlockPos, IHackableBlock> hackedBlocks = new HashMap<BlockPos, IHackableBlock>();
    private final Set<Entity> hackedEntities = new HashSet<Entity>();

    private HackTickTracker() {
    }

    private static HackTickTracker load(CompoundTag tag) {
        return new HackTickTracker().readNBT(tag);
    }

    public static HackTickTracker getInstance(Level level) {
        HackTickTracker hackTickTracker;
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            hackTickTracker = (HackTickTracker)s.getDataStorage().computeIfAbsent(new SavedData.Factory(HackTickTracker::new, HackTickTracker::load), DATA_NAME);
        } else {
            hackTickTracker = clientInstance;
        }
        return hackTickTracker;
    }

    private HackTickTracker readNBT(CompoundTag tag) {
        ListTag list = tag.getList("block_hacks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag sub = list.getCompound(i);
            BlockPos pos = new BlockPos(sub.getInt("x"), sub.getInt("y"), sub.getInt("z"));
            try {
                ResourceLocation id = new ResourceLocation(sub.getString("id"));
                CommonArmorRegistry.getInstance().getHackableBlockForId(id).ifPresentOrElse(hackable -> this.hackedBlocks.put(pos, (IHackableBlock)hackable), () -> Log.error("unknown hackable block ID '{}'", id));
                continue;
            }
            catch (ResourceLocationException e) {
                Log.error("invalid hackable block ID '{}'", sub.getString("id"));
            }
        }
        return this;
    }

    public CompoundTag save(CompoundTag pCompoundTag) {
        ListTag blockTag = new ListTag();
        this.hackedBlocks.forEach((pos, hackable) -> {
            CompoundTag sub = new CompoundTag();
            sub.putInt("x", pos.getX());
            sub.putInt("y", pos.getY());
            sub.putInt("z", pos.getZ());
            sub.putString("id", hackable.getHackableId().toString());
            blockTag.add((Object)sub);
        });
        pCompoundTag.put("block_hacks", (Tag)blockTag);
        return pCompoundTag;
    }

    void tick(Level world) {
        if (this.hackedBlocks.entrySet().removeIf(entry -> !((IHackableBlock)entry.getValue()).afterHackTick((BlockGetter)world, (BlockPos)entry.getKey()))) {
            this.setDirty();
        }
        this.hackedEntities.forEach(entity -> HackManager.getActiveHacks(entity).ifPresent(hacking -> {
            if (entity.isAlive() && !hacking.getCurrentHacks().isEmpty()) {
                hacking.tick((Entity)entity);
            }
        }));
        this.hackedEntities.removeIf(e -> !e.isAlive() || HackManager.getActiveHacks(e).map(hacking -> hacking.getCurrentHacks().isEmpty()).orElse(true) != false);
    }

    public void trackBlock(BlockPos pos, IHackableBlock iHackable) {
        this.hackedBlocks.put(pos, iHackable);
        this.setDirty();
    }

    public void trackEntity(Entity entity, IHackableEntity<?> iHackable) {
        HackManager.getActiveHacks(entity).ifPresent(hacking -> {
            hacking.addHackable(iHackable);
            this.hackedEntities.add(entity);
        });
    }

    public boolean isEntityTracked(Entity entity) {
        return this.hackedEntities.contains(entity);
    }
}

