/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.mixin.accessors.MobAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class HackableMobDisarm
implements IHackableEntity<Mob> {
    private static final ResourceLocation ID = PneumaticRegistry.RL("mob_disarm");

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    @Override
    @NotNull
    public Class<Mob> getHackableClass() {
        return Mob.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHack(Entity entity, Player player) {
        if (!(entity instanceof Mob)) return false;
        Mob mob = (Mob)entity;
        if (!IHackableEntity.super.canHack(entity, player)) return false;
        if (!Arrays.stream(EquipmentSlot.values()).anyMatch(slot -> !mob.getItemBySlot(slot).isEmpty())) return false;
        return true;
    }

    @Override
    public void addHackInfo(Mob entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.disarm", new Object[0]));
    }

    @Override
    public void addPostHackInfo(Mob entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.disarmed", new Object[0]));
    }

    @Override
    public int getHackTime(Mob entity, Player player) {
        return 60;
    }

    @Override
    public void onHackFinished(Mob entity, Player player) {
        if (!entity.level().isClientSide) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!this.doDisarm(entity, slot, player.getRandom())) continue;
                return;
            }
        }
    }

    private boolean doDisarm(Mob entity, EquipmentSlot slot, RandomSource rand) {
        if (entity.getItemBySlot(slot).isEmpty()) {
            return false;
        }
        MobAccess access = (MobAccess)entity;
        float[] dropChances = slot.getType() == EquipmentSlot.Type.ARMOR ? access.getArmorDropChances() : access.getHandDropChances();
        int slotIdx = slot.getIndex();
        boolean noDamage = dropChances[slotIdx] > 1.0f;
        ItemStack stack = entity.getItemBySlot(slot);
        if (!stack.isEmpty() && rand.nextFloat() < dropChances[slotIdx]) {
            if (!noDamage && stack.isDamageableItem()) {
                int k = Math.max(stack.getMaxDamage() - 25, 1);
                int l = stack.getMaxDamage() - rand.nextInt(rand.nextInt(k) + 1);
                stack.setDamageValue(Mth.clamp((int)l, (int)1, (int)k));
            }
            entity.spawnAtLocation(stack, 0.0f);
        }
        entity.setItemSlot(slot, ItemStack.EMPTY);
        return true;
    }
}

