/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.harvesting;

import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.common.registry.ModHarvestHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HarvestHandlerTree
extends HarvestHandler {
    private static final int SAPLING_PICK_RANGE = 8;

    @Override
    public boolean canHarvest(Level world, BlockGetter chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        return state.is(BlockTags.LOGS);
    }

    @Override
    public boolean harvestAndReplant(Level world, BlockGetter chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        List saplingItems;
        BlockState saplingState;
        this.harvest(world, chunkCache, pos, state, drone);
        Block saplingBlock = ModHarvestHandlers.TreePart.LOG.convert(state.getBlock(), ModHarvestHandlers.TreePart.SAPLING);
        if (saplingBlock != null && saplingBlock != Blocks.AIR && (saplingState = saplingBlock.defaultBlockState()).canSurvive((LevelReader)world, pos) && !(saplingItems = world.getEntitiesOfClass(ItemEntity.class, new AABB(pos).inflate(8.0), entityItem -> entityItem.getItem().getItem() == saplingBlock.asItem())).isEmpty()) {
            ((ItemEntity)saplingItems.get(0)).getItem().shrink(1);
            world.setBlockAndUpdate(pos, saplingState);
            return true;
        }
        return false;
    }
}

