/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.Arrays;
import java.util.HashSet;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class TemperatureData
implements INBTSerializable<CompoundTag> {
    private final Double[] temp = new Double[7];
    private boolean isMultisided;

    public static TemperatureData fromNBT(CompoundTag nbt) {
        TemperatureData data = new TemperatureData();
        data.deserializeNBT(nbt);
        return data;
    }

    private TemperatureData() {
        this.isMultisided = false;
    }

    public TemperatureData(BlockEntity provider) {
        Arrays.fill((Object[])this.temp, null);
        HashSet heatExchangers = new HashSet();
        for (Direction face : DirectionUtil.VALUES) {
            IOHelper.getCap(provider, PNCCapabilities.HEAT_EXCHANGER_BLOCK, face).ifPresent(heatExchangers::add);
        }
        if (heatExchangers.size() > 1) {
            this.isMultisided = true;
            for (Direction face : DirectionUtil.VALUES) {
                IOHelper.getCap(provider, PNCCapabilities.HEAT_EXCHANGER_BLOCK, face).ifPresent(h -> {
                    this.temp[face.get3DDataValue()] = h.getTemperature();
                });
            }
        } else if (heatExchangers.size() == 1) {
            this.isMultisided = false;
            IOHelper.getCap(provider, PNCCapabilities.HEAT_EXCHANGER_BLOCK, null).ifPresent(h -> {
                this.temp[6] = h.getTemperature();
            });
        } else {
            this.isMultisided = false;
        }
    }

    public boolean isMultisided() {
        return this.isMultisided;
    }

    public double getTemperature(Direction face) {
        return face == null ? this.temp[6] : this.temp[face.get3DDataValue()];
    }

    public boolean hasData(Direction face) {
        return face == null ? this.temp[6] != null : this.temp[face.get3DDataValue()] != null;
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.isMultisided()) {
            ListTag tagList = new ListTag();
            for (Direction face : DirectionUtil.VALUES) {
                if (this.temp[face.get3DDataValue()] == null) continue;
                CompoundTag heatTag = new CompoundTag();
                heatTag.putByte("side", (byte)face.get3DDataValue());
                heatTag.putInt("temp", (int)this.getTemperature(face));
                tagList.add((Object)heatTag);
            }
            nbt.put("heat", (Tag)tagList);
        } else {
            nbt.putInt("temp", (int)this.getTemperature(null));
        }
        return nbt;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.isMultisided()) {
            ListTag tagList = new ListTag();
            for (Direction face : DirectionUtil.VALUES) {
                CompoundTag heatTag = new CompoundTag();
                heatTag.putByte("side", (byte)face.get3DDataValue());
                heatTag.putInt("temp", (int)this.getTemperature(face));
                tagList.add((Object)heatTag);
            }
            nbt.put("heat", (Tag)tagList);
        } else {
            nbt.putInt("temp", (int)this.getTemperature(null));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.contains("heat")) {
            this.isMultisided = true;
            ListTag tagList = nbt.getList("heat", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag heatTag = tagList.getCompound(i);
                this.temp[heatTag.getByte((String)"side")] = heatTag.getInt("temp");
            }
        } else {
            this.isMultisided = false;
            this.temp[6] = nbt.getInt("temp");
        }
    }
}

