/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.inventory.slot.IPhantomSlot;
import me.desht.pneumaticcraft.common.inventory.slot.PlayerEquipmentSlot;
import me.desht.pneumaticcraft.common.inventory.slot.UpgradeSlot;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketUpdateGui;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public abstract class AbstractPneumaticCraftMenu<T extends AbstractPneumaticCraftBlockEntity>
extends AbstractContainerMenu
implements IGUIButtonSensitive {
    public final T blockEntity;
    private final List<SyncedField<?>> syncedFields = new ArrayList();
    private boolean firstTick = true;
    int playerSlotsStart;

    public AbstractPneumaticCraftMenu(MenuType type, int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(type, windowId, invPlayer, AbstractPneumaticCraftMenu.getTilePos(extraData));
    }

    public AbstractPneumaticCraftMenu(MenuType type, int windowId, Inventory invPlayer) {
        this(type, windowId, invPlayer, (BlockPos)null);
    }

    public AbstractPneumaticCraftMenu(MenuType type, int windowId, Inventory invPlayer, BlockPos tilePos) {
        super(type, windowId);
        if (tilePos != null) {
            BlockEntity te0 = invPlayer.player.level().getBlockEntity(tilePos);
            if (te0 instanceof AbstractPneumaticCraftBlockEntity) {
                this.blockEntity = (AbstractPneumaticCraftBlockEntity)te0;
                this.addSyncedFields(this.blockEntity);
            } else {
                this.blockEntity = null;
            }
        } else {
            this.blockEntity = null;
        }
    }

    public static void putHand(FriendlyByteBuf buf, InteractionHand hand) {
        buf.writeBoolean(hand == InteractionHand.MAIN_HAND);
    }

    static InteractionHand getHand(FriendlyByteBuf buf) {
        return buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    static BlockPos getTilePos(FriendlyByteBuf buf) {
        return buf.readBlockPos();
    }

    void addSyncedField(SyncedField<?> field) {
        this.syncedFields.add(field);
        field.setLazy(false);
    }

    void addSyncedFields(Object annotatedObject) {
        NetworkUtils.getSyncedFields(annotatedObject, GuiSynced.class).forEach(this::addSyncedField);
    }

    public void updateField(int index, Object value) {
        this.syncedFields.get(index).setValue(value);
        if (this.blockEntity != null) {
            ((AbstractPneumaticCraftBlockEntity)this.blockEntity).onGuiUpdate();
        }
    }

    public boolean stillValid(Player player) {
        return ((AbstractPneumaticCraftBlockEntity)this.blockEntity).isGuiUseableByPlayer(player);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        this.syncGuiFieldsToPlayers(null);
    }

    private void syncGuiFieldsToPlayers(@Nullable ServerPlayer player) {
        IntArrayList toUpdate = new IntArrayList();
        for (int i = 0; i < this.syncedFields.size(); ++i) {
            if (!this.syncedFields.get(i).update() && player == null && !this.firstTick) continue;
            toUpdate.add(i);
        }
        this.firstTick = false;
        if (!toUpdate.isEmpty()) {
            List<ServerPlayer> players;
            List<ServerPlayer> list = players = player == null ? ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers().stream().filter(p -> p.containerMenu == this).toList() : List.of(player);
            if (!players.isEmpty()) {
                toUpdate.forEach(idx -> {
                    PacketUpdateGui message = PacketUpdateGui.create(idx, this.syncedFields.get(idx));
                    players.forEach(p -> NetworkHandler.sendToPlayer(message, p));
                });
            }
        }
    }

    protected void addPlayerSlots(Inventory inventoryPlayer, int yOffset) {
        this.addPlayerSlots(inventoryPlayer, 8, yOffset);
    }

    protected void addPlayerSlots(Inventory inventoryPlayer, int xOffset, int yOffset) {
        this.playerSlotsStart = this.slots.size();
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.addSlot(new Slot((Container)inventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, xOffset + inventoryColumnIndex * 18, yOffset + inventoryRowIndex * 18));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.addSlot(new Slot((Container)inventoryPlayer, actionBarSlotIndex, xOffset + actionBarSlotIndex * 18, yOffset + 58));
        }
    }

    protected void addUpgradeSlots(int xBase, int yBase) {
        for (int i = 0; i < ((AbstractPneumaticCraftBlockEntity)this.blockEntity).getUpgradeHandler().getSlots(); ++i) {
            this.addSlot((Slot)new UpgradeSlot((AbstractPneumaticCraftBlockEntity)this.blockEntity, i, xBase + i % 2 * 18, yBase + i / 2 * 18));
        }
    }

    void addArmorSlots(Inventory inventoryPlayer, int xBase, int yBase) {
        for (int i = 0; i < 4; ++i) {
            this.addSlot(new PlayerEquipmentSlot(inventoryPlayer, ArmorUpgradeRegistry.ARMOR_SLOTS[i], xBase, yBase + i * 18));
        }
    }

    void addOffhandSlot(Inventory inventory, int x, int y) {
        this.addSlot(new PlayerEquipmentSlot(inventory, EquipmentSlot.OFFHAND, x, y));
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        Slot srcSlot = (Slot)this.slots.get(slot);
        if (srcSlot == null || !srcSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack srcStack = srcSlot.getItem().copy();
        ItemStack copyOfSrcStack = srcStack.copy();
        if (slot < this.playerSlotsStart ? !this.moveItemStackToHotbarOrInventory(srcStack, this.playerSlotsStart) : !this.moveItemStackTo(srcStack, 0, this.playerSlotsStart, false)) {
            return ItemStack.EMPTY;
        }
        srcSlot.set(srcStack);
        srcSlot.onQuickCraft(srcStack, copyOfSrcStack);
        srcSlot.onTake(player, srcStack);
        return copyOfSrcStack;
    }

    boolean moveItemStackToHotbarOrInventory(ItemStack stack, int startIndex) {
        return this.moveItemStackTo(stack, startIndex + 27, startIndex + 36, false) || this.moveItemStackTo(stack, startIndex, startIndex + 27, false);
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.slots.get(i);
                ItemStack itemstack = slot.getItem();
                if (!itemstack.isEmpty() && ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + stack.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(itemstack), Math.min(slot.getMaxStackSize(), stack.getMaxStackSize())))) {
                        stack.setCount(0);
                        itemstack.setCount(j);
                        slot.setChanged();
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        stack.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.setChanged();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(stack)) {
                    int limit = Math.min(slot1.getMaxStackSize(), slot1.getMaxStackSize(stack));
                    if (stack.getCount() > limit) {
                        slot1.set(stack.split(limit));
                    } else {
                        slot1.set(stack.split(stack.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.slots.get(slotId);
        if (slot instanceof IPhantomSlot) {
            this.slotClickPhantom(slot, dragType, clickType, player);
        } else {
            super.clicked(slotId, dragType, clickType, player);
        }
    }

    @Nonnull
    private ItemStack slotClickPhantom(Slot slot, int dragType, ClickType clickType, Player player) {
        ItemStack stack = ItemStack.EMPTY;
        if (clickType == ClickType.CLONE && dragType == 2) {
            if (((IPhantomSlot)slot).canAdjust()) {
                slot.set(ItemStack.EMPTY);
            }
        } else if (!(clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1)) {
            slot.setChanged();
            ItemStack stackSlot = slot.getItem();
            ItemStack stackHeld = this.getCarried();
            stack = stackSlot.copy();
            if (stackSlot.isEmpty()) {
                if (!stackHeld.isEmpty() && slot.mayPlace(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, dragType);
                }
            } else if (stackHeld.isEmpty()) {
                this.adjustPhantomSlot(slot, clickType, dragType);
                slot.onTake(player, this.getCarried());
            } else if (slot.mayPlace(stackHeld)) {
                if (this.canStacksMerge(stackSlot, stackHeld)) {
                    this.adjustPhantomSlot(slot, clickType, dragType);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, dragType);
                }
            }
        }
        return stack;
    }

    private boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        return !stack1.isEmpty() && !stack2.isEmpty() && ItemStack.isSameItemSameTags((ItemStack)stack1, (ItemStack)stack2);
    }

    private void adjustPhantomSlot(Slot slot, ClickType clickType, int dragType) {
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        ItemStack stackSlot = slot.getItem().copy();
        if (dragType == 1) {
            if (clickType == ClickType.QUICK_MOVE) {
                stackSlot.setCount(Math.min(stackSlot.getCount() * 2, slot.getMaxStackSize()));
            } else {
                stackSlot.setCount(Math.min(stackSlot.getCount() + 1, slot.getMaxStackSize()));
            }
        } else if (dragType == 0) {
            if (clickType == ClickType.QUICK_MOVE) {
                stackSlot.setCount(stackSlot.getCount() / 2);
            } else {
                stackSlot.shrink(1);
            }
        }
        slot.set(stackSlot);
    }

    private void fillPhantomSlot(Slot slot, ItemStack stackHeld, int dragType) {
        int stackSize;
        if (!((IPhantomSlot)slot).canAdjust()) {
            return;
        }
        int n = stackSize = dragType == 0 ? stackHeld.getCount() : 1;
        if (stackSize > slot.getMaxStackSize()) {
            stackSize = slot.getMaxStackSize();
        }
        ItemStack phantomStack = stackHeld.copy();
        phantomStack.setCount(stackSize);
        slot.set(phantomStack);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.blockEntity != null) {
            ((AbstractPneumaticCraftBlockEntity)this.blockEntity).handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onMenuOpen(PlayerContainerEvent.Open event) {
            AbstractContainerMenu abstractContainerMenu = event.getContainer();
            if (abstractContainerMenu instanceof AbstractPneumaticCraftMenu) {
                AbstractPneumaticCraftMenu pncMenu = (AbstractPneumaticCraftMenu)abstractContainerMenu;
                abstractContainerMenu = event.getEntity();
                if (abstractContainerMenu instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)abstractContainerMenu;
                    pncMenu.syncGuiFieldsToPlayers(sp);
                }
            }
        }
    }
}

