/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.amadron.AmadronUtil;
import me.desht.pneumaticcraft.common.amadron.ShoppingBasket;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.AmadronPlayerOffers;
import me.desht.pneumaticcraft.common.drone.DroneRegistry;
import me.desht.pneumaticcraft.common.entity.drone.AmadroneEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.AmadronAddTradeMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderResponse;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeRemoved;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class AmadronMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity> {
    public static final int HARD_MAX_STACKS = 36;
    public static final int HARD_MAX_MB = 576000;
    public final List<AmadronOffer> activeOffers = new ArrayList<AmadronOffer>(AmadronOfferManager.getInstance().getActiveOffers());
    private final ShoppingBasket shoppingBasket = new ShoppingBasket();
    private final InteractionHand hand;
    @GuiSynced
    public final boolean[] affordableOffers = new boolean[this.activeOffers.size()];
    @GuiSynced
    public EnumProblemState problemState = EnumProblemState.NO_PROBLEMS;
    @GuiSynced
    public int maxPlayerOffers = 0;
    @GuiSynced
    public int currentPlayerOffers = 0;
    @GuiSynced
    private boolean basketEmpty = true;

    public AmadronMenu(int windowId, Inventory invPlayer, InteractionHand hand) {
        super(ModMenuTypes.AMADRON.get(), windowId, invPlayer);
        this.hand = hand;
        this.addSyncedFields(this);
        Player player = invPlayer.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack tablet = player2.getItemInHand(hand);
            ShoppingBasket savedBasket = AmadronTabletItem.loadShoppingCart(tablet);
            ShoppingBasket availableOffers = new ShoppingBasket();
            this.activeOffers.forEach(offer -> availableOffers.setUnits(offer.getOfferId(), Math.max(savedBasket.getUnits(offer.getOfferId()), 1)));
            availableOffers.validate(tablet, false);
            for (int i = 0; i < this.activeOffers.size(); ++i) {
                ResourceLocation offerId = this.activeOffers.get(i).getOfferId();
                int wantedUnits = savedBasket.getUnits(offerId);
                int availableUnits = availableOffers.getUnits(offerId);
                boolean bl = this.affordableOffers[i] = availableUnits > 0;
                if (wantedUnits <= 0 || availableUnits <= 0) continue;
                this.shoppingBasket.setUnits(offerId, Math.min(availableUnits, wantedUnits));
                Objects.requireNonNull(player2.getServer()).tell((Runnable)new TickTask(player2.getServer().getTickCount(), () -> NetworkHandler.sendToPlayer(new PacketAmadronOrderResponse(offerId, availableUnits), player2)));
            }
            this.basketEmpty = this.shoppingBasket.isEmpty();
            this.currentPlayerOffers = AmadronOfferManager.getInstance().countPlayerOffers(player2.getGameProfile().getId());
            this.maxPlayerOffers = PneumaticCraftUtils.isPlayerOp((Player)player2) ? Integer.MAX_VALUE : (Integer)ConfigHelper.common().amadron.maxTradesPerPlayer.get();
            this.problemState = EnumProblemState.NO_PROBLEMS;
        }
    }

    public AmadronMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(windowId, playerInventory, buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public void updateBasket(ResourceLocation offerId, int amount) {
        this.shoppingBasket.setUnits(offerId, amount);
    }

    public boolean isBasketEmpty() {
        return this.basketEmpty;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    @Override
    public boolean stillValid(Player player) {
        if (player.getItemInHand(this.hand).getItem() == ModItems.AMADRON_TABLET.get()) {
            return PNCCapabilities.getAirHandler(player.getItemInHand(this.hand)).map(h -> {
                h.addAir(-1);
                if (h.getPressure() > 0.0f) {
                    return true;
                }
                player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.gui.tab.problems.notEnoughPressure"), false);
                return false;
            }).orElse(false);
        }
        return false;
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public void clickOffer(ResourceLocation offerId, int mouseButton, boolean shiftPressed, ServerPlayer player) {
        this.problemState = EnumProblemState.NO_PROBLEMS;
        if (AmadronOfferManager.getInstance().isActive(offerId)) {
            if (mouseButton == 2) {
                this.shoppingBasket.remove(offerId);
            } else if (shiftPressed) {
                if (mouseButton == 0) {
                    this.shoppingBasket.halve(offerId);
                } else {
                    int units = this.shoppingBasket.getUnits(offerId);
                    this.shoppingBasket.addUnitsToOffer(offerId, units == 0 ? 1 : units);
                }
            } else {
                this.shoppingBasket.addUnitsToOffer(offerId, mouseButton == 0 ? -1 : 1);
            }
            this.problemState = this.shoppingBasket.validate(player.getItemInHand(this.hand), true);
            if (this.problemState != EnumProblemState.NO_PROBLEMS) {
                this.shoppingBasket.syncToPlayer(player);
            } else {
                NetworkHandler.sendToPlayer(new PacketAmadronOrderResponse(offerId, this.shoppingBasket.getUnits(offerId)), player);
            }
        }
        this.basketEmpty = this.shoppingBasket.isEmpty();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        AmadronOffer offer;
        super.handleGUIButtonPress(tag, shiftHeld, player);
        if (tag.equals("order")) {
            if (this.takeOrder(player, player.getItemInHand(this.hand))) {
                NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.CHIRP.get(), SoundSource.PLAYERS, player.blockPosition(), 0.2f, 1.0f, false), player);
            }
        } else if (tag.equals("addPlayerTrade")) {
            this.openTradeGui(player);
        } else if (tag.startsWith("remove:") && shiftHeld && (offer = AmadronOfferManager.getInstance().getOffer(new ResourceLocation(tag.substring(7)))) instanceof AmadronPlayerOffer) {
            this.tryRemoveCustomOffer(player, (AmadronPlayerOffer)offer);
        }
    }

    private boolean takeOrder(ServerPlayer player, ItemStack amadronTablet) {
        if (!(amadronTablet.getItem() instanceof AmadronTabletItem)) {
            return false;
        }
        String playerName = player.getName().getString();
        boolean orderPlaced = false;
        for (ResourceLocation offerId : this.shoppingBasket) {
            GlobalPos fluidGPos;
            GlobalPos itemGPos;
            AmadroneEntity drone;
            AmadronOffer offer;
            int amount = this.shoppingBasket.getUnits(offerId);
            if (!AmadronOfferManager.getInstance().isActive(offerId) || amount <= 0 || !(offer = AmadronOfferManager.getInstance().getOffer(offerId)).isUsableByPlayer((Player)player) || (drone = AmadronMenu.retrieveOrder(playerName, offer, amount, itemGPos = AmadronTabletItem.getItemProvidingLocation(amadronTablet), fluidGPos = AmadronTabletItem.getFluidProvidingLocation(amadronTablet))) == null) continue;
            drone.setHandlingOffer(offer.getOfferId(), amount, amadronTablet, playerName, AmadroneEntity.AmadronAction.TAKING_PAYMENT);
            orderPlaced = true;
        }
        for (ResourceLocation offerId : this.shoppingBasket) {
            NetworkHandler.sendToPlayer(new PacketAmadronOrderResponse(offerId, 0), player);
        }
        this.shoppingBasket.clear();
        this.basketEmpty = true;
        return orderPlaced;
    }

    private void openTradeGui(ServerPlayer player) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.empty();
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                return new AmadronAddTradeMenu(windowId, playerInventory);
            }
        });
    }

    private void tryRemoveCustomOffer(ServerPlayer player, AmadronPlayerOffer offer) {
        if (offer.isRemovableBy((Player)player) && AmadronOfferManager.getInstance().removePlayerOffer(offer)) {
            if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeRemoval.get()).booleanValue()) {
                NetworkHandler.sendToAll(new PacketAmadronTradeRemoved(offer));
            }
            offer.returnStock();
            AmadronTabletItem.openGui(player, this.hand);
        }
    }

    public static AmadroneEntity retrieveOrder(String playerName, AmadronOffer offer, int units, GlobalPos itemGPos, GlobalPos liquidGPos) {
        boolean isAmadronRestock = playerName == null;
        return offer.getInput().apply(itemStack -> AmadronMenu.retrieveOrderItems(playerName, offer, units, itemGPos, isAmadronRestock), fluidStack -> AmadronMenu.retrieveOrderFluid(playerName, offer, units, liquidGPos, isAmadronRestock));
    }

    private static AmadroneEntity retrieveOrderItems(String playerName, AmadronOffer offer, int units, GlobalPos itemGPos, boolean isAmadronRestock) {
        if (itemGPos == null || !AmadronMenu.validateStockLevel(playerName, offer, units, isAmadronRestock)) {
            return null;
        }
        ItemStack queryingItems = offer.getInput().getItem();
        ItemStack[] stacks = AmadronUtil.buildStacks(queryingItems, units);
        if (stacks.length == 0) {
            Log.error("retrieveOrderItems: got empty itemstack list for offer {} x {} @ {}", units, queryingItems, itemGPos);
            return null;
        }
        AmadronMenu.reduceStockLevel(offer, units, isAmadronRestock);
        return (AmadroneEntity)DroneRegistry.getInstance().retrieveItemsAmazonStyle(itemGPos, stacks);
    }

    private static AmadroneEntity retrieveOrderFluid(String playerName, AmadronOffer offer, int units, GlobalPos liquidGPos, boolean isAmadronRestock) {
        if (liquidGPos == null || !AmadronMenu.validateStockLevel(playerName, offer, units, isAmadronRestock)) {
            return null;
        }
        FluidStack queryingFluid = AmadronUtil.buildFluidStack(offer.getInput().getFluid(), units);
        AmadronMenu.reduceStockLevel(offer, units, isAmadronRestock);
        return (AmadroneEntity)DroneRegistry.getInstance().retrieveFluidAmazonStyle(liquidGPos, queryingFluid);
    }

    private static void reduceStockLevel(AmadronOffer offer, int units, boolean isAmadronRestock) {
        if (!isAmadronRestock && (offer instanceof AmadronPlayerOffer || offer.getMaxStock() >= 0)) {
            offer.setStock(offer.getStock() - units);
            if (offer instanceof AmadronPlayerOffer) {
                AmadronPlayerOffers.save();
            }
            NetworkHandler.sendNonLocal(new PacketAmadronStockUpdate(offer.getOfferId(), offer.getStock()));
        }
    }

    public static boolean validateStockLevel(String playerName, AmadronOffer offer, int units, boolean isAmadronRestock) {
        if (!isAmadronRestock && offer.getStock() >= 0 && units > offer.getStock()) {
            Log.warning("ignoring suspicious order from player [{}] for {} x {} - only {} in stock right now!", playerName, units, offer, offer.getStock());
            return false;
        }
        return true;
    }

    public int getShoppingBasketUnits(ResourceLocation offerId) {
        return this.shoppingBasket.getUnits(offerId);
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide && player.getItemInHand(this.hand).getItem() == ModItems.AMADRON_TABLET.get()) {
            AmadronTabletItem.saveShoppingCart(player.getItemInHand(this.hand), this.shoppingBasket);
        }
    }

    public static enum EnumProblemState implements ITranslatableEnum
    {
        NO_PROBLEMS("noProblems"),
        NO_INVENTORY("noInventory"),
        NOT_ENOUGH_ITEM_SPACE("notEnoughItemSpace"),
        NOT_ENOUGH_FLUID_SPACE("notEnoughFluidSpace"),
        NOT_ENOUGH_ITEMS("notEnoughItems"),
        NOT_ENOUGH_FLUID("notEnoughFluid"),
        OUT_OF_STOCK("outOfStock"),
        NOT_ENOUGH_STOCK("notEnoughStock"),
        TOO_MANY_ITEMS("tooManyItems"),
        TOO_MUCH_FLUID("tooMuchFluid");

        private final String locKey;

        private EnumProblemState(String locKey) {
            this.locKey = locKey;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems.amadron." + this.locKey;
        }

        public EnumProblemState addProblem(EnumProblemState problem) {
            return problem == NO_PROBLEMS ? this : problem;
        }
    }
}

