/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.processing.EtchingTankBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.UVLightBoxBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.slot.OutputOnlySlot;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class EtchingTankMenu
extends AbstractPneumaticCraftMenu<EtchingTankBlockEntity> {
    public EtchingTankMenu(int windowId, Inventory playerInv, BlockPos pos) {
        super(ModMenuTypes.ETCHING_TANK.get(), windowId, playerInv, pos);
        for (int i = 0; i < 25; ++i) {
            int x = 8 + 18 * (i % 5);
            int y = 18 + 18 * (i / 5);
            this.addSlot((Slot)new SlotPCB(((EtchingTankBlockEntity)this.blockEntity).getItemHandler(), i, x, y));
        }
        this.addSlot((Slot)new OutputOnlySlot(((EtchingTankBlockEntity)this.blockEntity).getOutputHandler(), 0, 104, 18));
        this.addSlot((Slot)new OutputOnlySlot(((EtchingTankBlockEntity)this.blockEntity).getFailedHandler(), 0, 104, 90));
        this.addPlayerSlots(playerInv, 125);
    }

    public EtchingTankMenu(int windowId, Inventory playerInv, FriendlyByteBuf buffer) {
        this(windowId, playerInv, EtchingTankMenu.getTilePos(buffer));
    }

    private static class SlotPCB
    extends SlotItemHandler {
        SlotPCB(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return stack.getItem() == ModItems.EMPTY_PCB.get() && UVLightBoxBlockEntity.getExposureProgress(stack) > 0;
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

