/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.item.DrillBitItem;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class JackhammerSetupMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity> {
    private final JackHammerItem.DrillBitHandler drillBitHandler;
    private final JackHammerItem.EnchantmentHandler enchantmentHandler;
    private final InteractionHand hand;

    public JackhammerSetupMenu(int windowId, Inventory invPlayer, FriendlyByteBuf buffer) {
        this(windowId, invPlayer, JackhammerSetupMenu.getHand(buffer));
    }

    public JackhammerSetupMenu(int windowId, Inventory invPlayer, InteractionHand hand) {
        super(ModMenuTypes.JACKHAMMER_SETUP.get(), windowId, invPlayer);
        this.hand = hand;
        this.drillBitHandler = JackHammerItem.getDrillBitHandler(invPlayer.player.getItemInHand(hand));
        if (this.drillBitHandler != null) {
            this.addSlot((Slot)new SlotDrillBit(this.drillBitHandler, 0, 128, 19));
        }
        this.enchantmentHandler = JackHammerItem.getEnchantmentHandler(invPlayer.player.getItemInHand(hand));
        if (this.enchantmentHandler != null) {
            this.addSlot((Slot)new SlotEnchantmentHandler(this.enchantmentHandler, 0, 96, 19));
        }
        this.addPlayerSlots(invPlayer, 100);
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.drillBitHandler.save();
        this.enchantmentHandler.save();
    }

    @Override
    public boolean stillValid(Player player) {
        return player.getItemInHand(this.hand).getItem() == ModItems.JACKHAMMER.get();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        ItemStack hammerStack = player.getItemInHand(this.hand);
        if (tag.startsWith("digmode:") && hammerStack.getItem() instanceof JackHammerItem) {
            try {
                DrillBitItem.DrillBitType ourBit = ((JackHammerItem)hammerStack.getItem()).getDrillBit(hammerStack);
                JackHammerItem.DigMode newDigMode = JackHammerItem.DigMode.valueOf(tag.substring(8));
                if (ourBit.getBitQuality() >= newDigMode.getBitType().getBitQuality() || newDigMode == JackHammerItem.DigMode.MODE_1X1) {
                    JackHammerItem.setDigMode(hammerStack, newDigMode);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    private static class SlotDrillBit
    extends SlotItemHandler {
        public SlotDrillBit(JackHammerItem.DrillBitHandler itemHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return stack.getItem() instanceof DrillBitItem;
        }

        public void setChanged() {
            ((JackHammerItem.DrillBitHandler)this.getItemHandler()).save();
        }

        public void onQuickCraft(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
            ((JackHammerItem.DrillBitHandler)this.getItemHandler()).save();
        }
    }

    private static class SlotEnchantmentHandler
    extends SlotItemHandler {
        public SlotEnchantmentHandler(JackHammerItem.EnchantmentHandler itemHandler, int index, int xPosition, int yPosition) {
            super((IItemHandler)itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return JackHammerItem.EnchantmentHandler.validateBook(stack);
        }

        public void onQuickCraft(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
            ((JackHammerItem.EnchantmentHandler)this.getItemHandler()).save();
        }

        public void setChanged() {
            ((JackHammerItem.EnchantmentHandler)this.getItemHandler()).save();
        }
    }
}

