/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.slot.PhantomSlot;
import me.desht.pneumaticcraft.common.inventory.slot.UnstackablePhantomSlot;
import me.desht.pneumaticcraft.common.item.logistics.AbstractLogisticsFrameItem;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.semiblock.ISyncableSemiblockItem;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class LogisticsMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity>
implements ISyncableSemiblockItem {
    public final AbstractLogisticsFrameEntity logistics;
    private final boolean itemContainer;

    public LogisticsMenu(MenuType<?> containerType, int i, Inventory playerInventory, int entityId) {
        super(containerType, i, playerInventory);
        Level world = playerInventory.player.level();
        if (entityId == -1) {
            this.logistics = AbstractLogisticsFrameEntity.fromItemStack(world, playerInventory.player, this.getHeldLogisticsFrame(playerInventory.player));
            this.itemContainer = true;
        } else {
            Entity e = world.getEntity(entityId);
            if (e instanceof AbstractLogisticsFrameEntity) {
                this.logistics = (AbstractLogisticsFrameEntity)e;
            } else {
                this.logistics = null;
                Log.error("no logistics frame entity for id {}!", entityId);
            }
            this.itemContainer = false;
        }
        if (this.logistics != null) {
            AbstractLogisticsFrameEntity.ItemFilterHandler requests = this.logistics.getItemFilterHandler();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.addSlot((Slot)(this.logistics.canFilterStack() ? new PhantomSlot((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29) : new UnstackablePhantomSlot((IItemHandler)requests, y * 9 + x, x * 18 + 8, y * 18 + 29)));
                }
            }
            this.addPlayerSlots(playerInventory, 134);
        }
    }

    private LogisticsMenu(MenuType logisticsFrameRequester, int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(logisticsFrameRequester, i, playerInventory, buffer.readVarInt());
    }

    private ItemStack getHeldLogisticsFrame(Player player) {
        if (player.getMainHandItem().getItem() instanceof AbstractLogisticsFrameItem) {
            return player.getMainHandItem();
        }
        if (player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof AbstractLogisticsFrameItem) {
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        return ItemStack.EMPTY;
    }

    public boolean isItemContainer() {
        return this.itemContainer;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        super.handleGUIButtonPress(tag, shiftHeld, player);
        if (this.logistics != null) {
            this.logistics.handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return this.logistics != null && this.logistics.isValid();
    }

    public void removed(Player player) {
        if (this.itemContainer && this.logistics != null && !player.getCommandSenderWorld().isClientSide) {
            this.syncSemiblockItemFromClient(player, null);
        }
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot srcSlot = (Slot)this.slots.get(slotIndex);
        if (slotIndex >= this.playerSlotsStart && srcSlot != null && srcSlot.hasItem()) {
            ItemStack stackInSlot = srcSlot.getItem();
            for (int i = 0; i < 27; ++i) {
                Slot slot = (Slot)this.slots.get(i);
                if (slot.hasItem()) continue;
                ItemStack s = this.logistics.canFilterStack() ? stackInSlot.copy() : ItemHandlerHelper.copyStackWithSize((ItemStack)stackInSlot, (int)1);
                slot.set(s);
                break;
            }
        }
        return ItemStack.EMPTY;
    }

    public static LogisticsMenu createProviderContainer(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new LogisticsMenu(ModMenuTypes.LOGISTICS_FRAME_PROVIDER.get(), i, playerInventory, buffer);
    }

    public static LogisticsMenu createRequesterContainer(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new LogisticsMenu(ModMenuTypes.LOGISTICS_FRAME_REQUESTER.get(), i, playerInventory, buffer);
    }

    public static LogisticsMenu createStorageContainer(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new LogisticsMenu(ModMenuTypes.LOGISTICS_FRAME_STORAGE.get(), i, playerInventory, buffer);
    }

    @Override
    public void syncSemiblockItemFromClient(Player player, FriendlyByteBuf payload) {
        if (this.logistics != null) {
            ItemStack stack;
            if (payload != null) {
                this.logistics.readFromBuf(payload);
            }
            if (!(stack = this.getHeldLogisticsFrame(player)).isEmpty()) {
                CompoundTag subtag = this.logistics.serializeNBT(new CompoundTag());
                stack.getOrCreateTag().put("EntityTag", (Tag)subtag);
            }
        }
    }
}

