/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class MinigunMagazineMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity> {
    private final MinigunItem.MagazineHandler gunInv;
    private final InteractionHand hand;

    public MinigunMagazineMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, MinigunMagazineMenu.getHand(buffer));
    }

    public MinigunMagazineMenu(int windowId, Inventory playerInventory, InteractionHand hand) {
        super(ModMenuTypes.MINIGUN_MAGAZINE.get(), windowId, playerInventory);
        this.hand = hand;
        MinigunItem minigun = (MinigunItem)playerInventory.player.getItemInHand(hand).getItem();
        this.gunInv = minigun.getMagazine(playerInventory.player.getItemInHand(hand));
        for (int i = 0; i < this.gunInv.getSlots(); ++i) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.gunInv, i, 26 + i % 2 * 18, 26 + i / 2 * 18));
        }
        this.addPlayerSlots(playerInventory, 84);
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.gunInv.save();
    }

    @Override
    public boolean stillValid(Player player) {
        return player.getItemInHand(this.hand).getItem() == ModItems.MINIGUN.get();
    }

    @Override
    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (clickType == ClickType.CLONE && dragType == 2 && slotId >= 0 && slotId < 4) {
            ItemStack gunStack = player.getItemInHand(this.hand);
            if (gunStack.getItem() instanceof MinigunItem) {
                int slot = MinigunItem.getLockedSlot(gunStack);
                if (slot == slotId) {
                    NBTUtils.removeTag(gunStack, "LockedSlot");
                } else {
                    NBTUtils.setInteger(gunStack, "LockedSlot", slotId);
                }
                if (player.level().isClientSide) {
                    player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.0f);
                }
            }
        } else {
            super.clicked(slotId, dragType, clickType, player);
            this.gunInv.save();
        }
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

