/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSendNBTPacket;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ProgrammerMenu
extends AbstractPneumaticCraftMenu<ProgrammerBlockEntity> {
    private final boolean hiRes;

    public ProgrammerMenu(int i, Inventory playerInventory, BlockPos pos) {
        super(ModMenuTypes.PROGRAMMER.get(), i, playerInventory, pos);
        this.hiRes = playerInventory.player.level().isClientSide && ClientUtils.isScreenHiRes();
        int xBase = this.hiRes ? 270 : 95;
        int yBase = this.hiRes ? 430 : 174;
        this.addSlot((Slot)new SlotItemHandler(((ProgrammerBlockEntity)this.blockEntity).getItemHandler(), 0, this.hiRes ? 676 : 326, 15){

            public boolean mayPlace(@Nonnull ItemStack stack) {
                return ProgrammerMenu.isProgrammableItem(stack);
            }
        });
        this.addPlayerSlots(playerInventory, xBase, yBase);
    }

    public ProgrammerMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, ProgrammerMenu.getTilePos(buffer));
    }

    public boolean isHiRes() {
        return this.hiRes;
    }

    private static boolean isProgrammableItem(@Nonnull ItemStack stack) {
        return stack.getItem() instanceof IProgrammable && ((IProgrammable)stack.getItem()).canProgram(stack);
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        if (((ProgrammerBlockEntity)this.blockEntity).nonNullLevel().getGameTime() % 20L == 0L) {
            for (Direction d : DirectionUtil.VALUES) {
                BlockEntity neighbor = ((ProgrammerBlockEntity)this.blockEntity).getCachedNeighbor(d);
                if (neighbor == null || !IOHelper.getInventoryForBlock(neighbor, d.getOpposite()).isPresent()) continue;
                ProgrammerMenu self = this;
                List<ServerPlayer> players = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers().stream().filter(p -> p.containerMenu == self).toList();
                if (players.isEmpty()) continue;
                players.forEach(p -> NetworkHandler.sendToPlayer(PacketSendNBTPacket.forBlockEntity(neighbor), p));
            }
        }
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player par1EntityPlayer, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot srcSlot = (Slot)this.slots.get(slotIndex);
        if (srcSlot != null && srcSlot.hasItem()) {
            ItemStack stackInSlot = srcSlot.getItem();
            stack = stackInSlot.copy();
            if (slotIndex == 0) {
                if (!this.moveItemStackTo(stackInSlot, 1, 36, false)) {
                    return ItemStack.EMPTY;
                }
                srcSlot.onQuickCraft(stackInSlot, stack);
            } else if (ProgrammerMenu.isProgrammableItem(stack)) {
                if (!this.moveItemStackTo(stackInSlot, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
                srcSlot.onQuickCraft(stackInSlot, stack);
            }
            if (stackInSlot.isEmpty()) {
                srcSlot.set(ItemStack.EMPTY);
            } else {
                srcSlot.setChanged();
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            srcSlot.onTake(par1EntityPlayer, stackInSlot);
        }
        return stack;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (playerIn.level().isClientSide) {
            ProgrammerScreen.onCloseFromContainer();
        }
    }
}

