/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.processing.RefineryControllerBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RefineryMenu
extends AbstractPneumaticCraftMenu<RefineryControllerBlockEntity> {
    public RefineryMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, RefineryMenu.getTilePos(buffer));
    }

    public RefineryMenu(int i, Inventory playerInventory, BlockPos pos) {
        super(ModMenuTypes.REFINERY.get(), i, playerInventory, pos);
        if (playerInventory.player instanceof ServerPlayer) {
            ((RefineryControllerBlockEntity)this.blockEntity).incPlayersUsing();
        }
        this.addPlayerSlots(playerInventory, 108);
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        if (pPlayer instanceof ServerPlayer) {
            ((RefineryControllerBlockEntity)this.blockEntity).decPlayersUsing();
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return ((RefineryControllerBlockEntity)this.blockEntity).isGuiUseableByPlayer(player);
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player par1EntityPlayer, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot srcSlot = (Slot)this.slots.get(slotIndex);
        if (srcSlot != null && srcSlot.hasItem()) {
            ItemStack stackInSlot = srcSlot.getItem();
            stack = stackInSlot.copy();
            if (slotIndex < 27 ? !this.moveItemStackTo(stackInSlot, 27, 36, false) : !this.moveItemStackTo(stackInSlot, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            srcSlot.onQuickCraft(stackInSlot, stack);
            if (stackInSlot.isEmpty()) {
                srcSlot.set(ItemStack.EMPTY);
            } else {
                srcSlot.setChanged();
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            srcSlot.onTake(par1EntityPlayer, stackInSlot);
        }
        return stack;
    }
}

