/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.function.Predicate;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractChestUpgradeKitItem
extends Item {
    private final Supplier<? extends Block> chestBlock;
    private final Predicate<BlockState> blockPredicate;

    private AbstractChestUpgradeKitItem(Item.Properties properties, Supplier<? extends Block> chestBlock, Predicate<BlockState> blockPredicate) {
        super(properties);
        this.chestBlock = chestBlock;
        this.blockPredicate = blockPredicate;
    }

    protected void onUpgraded(BlockState oldState, UseOnContext context) {
        if (oldState.is(Tags.Blocks.CHESTS_WOODEN)) {
            PneumaticCraftUtils.dropItemOnGround(new ItemStack((ItemLike)oldState.getBlock()), context.getLevel(), context.getClickedPos().relative(context.getClickedFace()));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level world = context.getLevel();
        BlockState state = world.getBlockState(pos = context.getClickedPos());
        if (this.blockPredicate.test(state)) {
            if (!world.isClientSide) {
                Direction facing = state.hasProperty((Property)HorizontalDirectionalBlock.FACING) ? (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING) : Direction.NORTH;
                BlockEntity te = world.getBlockEntity(pos);
                NonNullList inv = NonNullList.create();
                if (te != null) {
                    IOHelper.getInventoryForBlock(te).ifPresent(handler -> {
                        Pair<Integer, Integer> range = this.getInvRange(state, (IItemHandler)handler);
                        for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                            inv.add((Object)handler.extractItem(i, Integer.MAX_VALUE, false));
                        }
                    });
                }
                BlockState newState = this.chestBlock.get().defaultBlockState();
                world.setBlockAndUpdate(pos, (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing));
                if (context.getPlayer() instanceof ServerPlayer) {
                    world.playSound(null, pos, SoundEvents.ANVIL_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.levelEvent(context.getPlayer(), 2001, pos, Block.getId((BlockState)newState));
                }
                PneumaticCraftUtils.getTileEntityAt((BlockGetter)world, pos, AbstractPneumaticCraftBlockEntity.class).ifPresent(teRC -> {
                    IItemHandler chestInv = teRC.getItemHandler();
                    for (int i = 0; i < inv.size(); ++i) {
                        if (i < chestInv.getSlots()) {
                            chestInv.insertItem(i, (ItemStack)inv.get(i), false);
                            continue;
                        }
                        PneumaticCraftUtils.dropItemOnGround((ItemStack)inv.get(i), world, pos.relative(context.getClickedFace()));
                    }
                });
                this.onUpgraded(state, context);
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private Pair<Integer, Integer> getInvRange(BlockState state, IItemHandler handler) {
        if (state.getBlock() == Blocks.CHEST && state.hasProperty((Property)ChestBlock.TYPE)) {
            return switch ((ChestType)state.getValue((Property)ChestBlock.TYPE)) {
                default -> throw new IncompatibleClassChangeError();
                case ChestType.RIGHT -> Pair.of((Object)0, (Object)(handler.getSlots() / 2));
                case ChestType.LEFT -> Pair.of((Object)(handler.getSlots() / 2), (Object)handler.getSlots());
                case ChestType.SINGLE -> Pair.of((Object)0, (Object)handler.getSlots());
            };
        }
        return Pair.of((Object)0, (Object)handler.getSlots());
    }

    public static class Smart
    extends AbstractChestUpgradeKitItem {
        public Smart() {
            super(ModItems.defaultProps(), (Supplier<? extends Block>)ModBlocks.SMART_CHEST, state -> state.is(Tags.Blocks.CHESTS_WOODEN) || state.getBlock() == ModBlocks.REINFORCED_CHEST.get());
        }

        @Override
        protected void onUpgraded(BlockState oldState, UseOnContext context) {
            if (oldState.getBlock() == ModBlocks.REINFORCED_CHEST.get()) {
                PneumaticCraftUtils.dropItemOnGround(new ItemStack((ItemLike)ModBlocks.REINFORCED_CHEST.get()), context.getLevel(), context.getClickedPos().relative(context.getClickedFace()));
            } else {
                super.onUpgraded(oldState, context);
            }
        }
    }

    public static class Reinforced
    extends AbstractChestUpgradeKitItem {
        public Reinforced() {
            super(ModItems.defaultProps(), (Supplier<? extends Block>)ModBlocks.REINFORCED_CHEST, state -> state.is(Tags.Blocks.CHESTS_WOODEN));
        }
    }
}

