/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BandageItem
extends Item {
    public BandageItem() {
        super(ModItems.defaultProps().stacksTo(16));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            player.setHealth(player.getHealth() + ((Double)ConfigHelper.common().general.bandageHealthRestored.get()).floatValue());
            stack.shrink(1);
            int cooldown = (Integer)ConfigHelper.common().general.bandageCooldown.get();
            if (cooldown > 0) {
                player.getCooldowns().addCooldown(stack.getItem(), cooldown);
            }
            if (worldIn.isClientSide) {
                Vec3 pos = player.getEyePosition(1.0f).add(player.getLookAngle().scale(0.5));
                for (int i = 0; i < 5; ++i) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.HEART, pos.x + (double)worldIn.random.nextFloat() - 0.5, pos.y + (double)worldIn.random.nextFloat() - 0.5, pos.z + (double)worldIn.random.nextFloat() - 0.5, 0.0, 0.05, 0.0);
                }
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack) {
        return (Integer)ConfigHelper.common().general.bandageUseTime.get();
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }
}

