/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CamoApplicatorItem
extends PressurizableItem {
    public CamoApplicatorItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public Component getName(ItemStack stack) {
        BlockState camoState = CamoApplicatorItem.getCamoState(stack, null);
        Component disp = super.getName(stack);
        if (camoState != null) {
            return disp.copy().append(": ").append(CamoApplicatorItem.getCamoStateDisplayName(camoState)).withStyle(ChatFormatting.YELLOW);
        }
        return disp;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.isShiftKeyDown()) {
            if (!worldIn.isClientSide) {
                CamoApplicatorItem.setCamoState(playerIn.getItemInHand(handIn), null);
            } else if (CamoApplicatorItem.getCamoState(playerIn.getItemInHand(handIn), playerIn.level()) != null) {
                playerIn.playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.0f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.getItemInHand(handIn));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.getItemInHand(handIn));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        if (player != null && !level.isClientSide) {
            if (player.isCrouching()) {
                CamoApplicatorItem.setCamoState(stack, null);
                level.playSound(null, ctx.getClickedPos(), (SoundEvent)ModSounds.CHIRP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                BlockEntity te = level.getBlockEntity(pos);
                BlockState state = level.getBlockState(pos);
                if (!(te instanceof CamouflageableBlockEntity)) {
                    CamoApplicatorItem.setCamoState(stack, state);
                    level.playSound(null, ctx.getClickedPos(), (SoundEvent)ModSounds.CHIRP.get(), SoundSource.PLAYERS, 1.0f, 2.0f);
                } else {
                    BlockState particleState;
                    ItemStack camoStack;
                    CamouflageableBlockEntity camoTE = (CamouflageableBlockEntity)te;
                    IAirHandlerItem airHandler = PNCCapabilities.getAirHandler(stack).orElseThrow(RuntimeException::new);
                    if (!player.isCreative() && airHandler.getPressure() < 0.1f) {
                        return InteractionResult.FAIL;
                    }
                    BlockState newCamo = CamoApplicatorItem.getCamoState(stack, level);
                    BlockState existingCamo = camoTE.getCamouflage();
                    if (existingCamo == newCamo) {
                        level.playSound(null, ctx.getClickedPos(), SoundEvents.COMPARATOR_CLICK, SoundSource.PLAYERS, 1.0f, 2.0f);
                        return InteractionResult.SUCCESS;
                    }
                    if (newCamo != null && !player.isCreative()) {
                        camoStack = CamouflageableBlockEntity.getStackForState(newCamo);
                        if (!PneumaticCraftUtils.consumeInventoryItem(player.getInventory(), camoStack)) {
                            player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.camo.notEnoughBlocks").append(camoStack.getHoverName()).withStyle(ChatFormatting.RED), true);
                            NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundSource.PLAYERS, pos, 1.0f, 2.0f, true), level, pos);
                            return InteractionResult.FAIL;
                        }
                    }
                    if (existingCamo != null && !player.isCreative()) {
                        camoStack = CamouflageableBlockEntity.getStackForState(existingCamo);
                        ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, camoStack);
                        level.addFreshEntity((Entity)entity);
                        entity.playerTouch(player);
                    }
                    if (!player.isCreative()) {
                        airHandler.addAir(-50);
                    }
                    camoTE.setCamouflage(newCamo);
                    BlockState blockState = particleState = newCamo == null ? existingCamo : newCamo;
                    if (particleState != null) {
                        player.getCommandSenderWorld().levelEvent(2001, pos, Block.getId((BlockState)particleState));
                    }
                    NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.SHORT_HISS.get(), SoundSource.PLAYERS, pos, 1.0f, 1.0f, true), level, pos);
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private static void setCamoState(ItemStack stack, BlockState state) {
        CompoundTag tag = stack.getTag();
        if (tag == null) {
            tag = new CompoundTag();
        }
        if (state == null) {
            tag.remove("CamoState");
        } else {
            tag.put("CamoState", (Tag)NbtUtils.writeBlockState((BlockState)state));
        }
        stack.setTag(tag);
    }

    private static BlockState getCamoState(ItemStack stack, Level level) {
        CompoundTag tag = stack.getTag();
        if (tag != null && tag.contains("CamoState")) {
            return NbtUtils.readBlockState((HolderGetter)(level == null ? BuiltInRegistries.BLOCK.asLookup() : level.holderLookup(Registries.BLOCK)), (CompoundTag)tag.getCompound("CamoState"));
        }
        return null;
    }

    public static Component getCamoStateDisplayName(BlockState state) {
        if (state != null) {
            return new ItemStack((ItemLike)state.getBlock().asItem()).getHoverName();
        }
        return Component.literal((String)"<?>");
    }
}

