/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.item.IFilteringItem;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.gui.ClassifyFilterScreen;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class ClassifyFilterItem
extends Item
implements IFilteringItem {
    private static final String NBT_FILTER = "Filter";
    private static final String NBT_CONDITIONS = "Conditions";
    private static final String NBT_MATCH_ALL = "MatchAll";

    public ClassifyFilterItem() {
        super(ModItems.defaultProps());
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (pLevel.isClientSide) {
            ClassifyFilterScreen.openGui(stack.getHoverName(), pUsedHand);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public boolean matchFilter(ItemStack filterStack, ItemStack stack) {
        Validate.isTrue((boolean)(filterStack.getItem() instanceof ClassifyFilterItem), (String)"filter item stack is not a Classify Filter!", (Object[])new Object[0]);
        return FilterSettings.fromStack(filterStack).test(stack);
    }

    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        FilterSettings settings = FilterSettings.fromStack(pStack);
        pTooltipComponents.add((Component)ClassifyFilterItem.xlateMatch(settings.matchAll()).withStyle(ChatFormatting.YELLOW));
        for (FilterCondition c : settings.filterConditions()) {
            pTooltipComponents.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate(c.getTranslationKey(), new Object[0])).withStyle(ChatFormatting.GOLD));
        }
    }

    private static boolean isCookable(RecipeType<? extends AbstractCookingRecipe> type, ItemStack stack) {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().overworld();
        if (level == null) {
            return false;
        }
        SimpleContainer c = new SimpleContainer(1);
        c.setItem(0, stack);
        return level.getRecipeManager().getRecipeFor(type, (Container)c, (Level)level).isPresent();
    }

    public static MutableComponent xlateMatch(boolean matchAll) {
        return PneumaticCraftUtils.xlate(matchAll ? "pneumaticcraft.gui.tooltip.filter.matchAll" : "pneumaticcraft.gui.tooltip.filter.matchAny", new Object[0]);
    }

    public record FilterSettings(boolean matchAll, Collection<FilterCondition> filterConditions) implements Predicate<ItemStack>
    {
        private static final FilterSettings NONE = new FilterSettings(false, Collections.emptyList());

        public static FilterSettings fromStack(ItemStack filterStack) {
            CompoundTag tag = filterStack.getTagElement(ClassifyFilterItem.NBT_FILTER);
            if (tag == null) {
                return NONE;
            }
            ListTag l = tag.getList(ClassifyFilterItem.NBT_CONDITIONS, 8);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < l.size(); ++i) {
                try {
                    builder.add((Object)FilterCondition.valueOf(l.getString(i)));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return new FilterSettings(tag.getBoolean(ClassifyFilterItem.NBT_MATCH_ALL), (Collection<FilterCondition>)builder.build());
        }

        public void save(ItemStack stack) {
            CompoundTag subTag = new CompoundTag();
            subTag.putBoolean(ClassifyFilterItem.NBT_MATCH_ALL, this.matchAll);
            ListTag l = new ListTag();
            this.filterConditions.forEach(c -> l.add((Object)StringTag.valueOf((String)c.toString())));
            subTag.put(ClassifyFilterItem.NBT_CONDITIONS, (Tag)l);
            stack.getOrCreateTag().put(ClassifyFilterItem.NBT_FILTER, (Tag)subTag);
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.matchAll ? this.filterConditions.stream().allMatch(c -> c.test(stack)) : this.filterConditions.stream().anyMatch(c -> c.test(stack));
        }
    }

    public static enum FilterCondition implements ITranslatableEnum,
    Predicate<ItemStack>
    {
        FUEL_ITEM((ItemLike)Items.COAL, s -> s.getBurnTime(RecipeType.SMELTING) > 0),
        EDIBLE((ItemLike)Items.BREAD, ItemStack::isEdible),
        PLACEABLE((ItemLike)Items.STONE, s -> s.getItem() instanceof BlockItem),
        FLUID_CONTAINER((ItemLike)Items.BUCKET, s -> IOHelper.getFluidHandlerForItem(s).isPresent()),
        UNSTACKABLE((ItemLike)Items.WRITABLE_BOOK, s -> s.getMaxStackSize() == 1),
        WEARABLE((ItemLike)Items.LEATHER_HELMET, s -> s.getItem() instanceof ArmorItem),
        TOOL((ItemLike)Items.IRON_PICKAXE, s -> s.getItem() instanceof TieredItem),
        WEAPON((ItemLike)Items.IRON_SWORD, s -> s.getItem() instanceof SwordItem || s.getItem() instanceof AxeItem || s.getItem() instanceof ProjectileWeaponItem),
        ENCHANTABLE((ItemLike)Items.BOOK, s -> s.isEnchantable() && !s.isEnchanted()),
        ENCHANTED((ItemLike)Items.ENCHANTED_BOOK, ItemStack::isEnchanted),
        SMELTABLE((ItemLike)Blocks.FURNACE, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.SMELTING, s)),
        BLASTABLE((ItemLike)Blocks.BLAST_FURNACE, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.BLASTING, s)),
        SMOKABLE((ItemLike)Blocks.SMOKER, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.SMOKING, s)),
        CAMPFIRE_COOKABLE((ItemLike)Blocks.CAMPFIRE, s -> ClassifyFilterItem.isCookable((RecipeType<? extends AbstractCookingRecipe>)RecipeType.CAMPFIRE_COOKING, s));

        private final ItemStack icon;
        private final Predicate<ItemStack> predicate;

        private FilterCondition(ItemLike icon, Predicate<ItemStack> predicate) {
            this.icon = new ItemStack(icon);
            this.predicate = predicate;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.predicate.test(stack);
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tooltip.filter." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

