/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

record CompressedIronArmorMaterial(float knockbackResistance) implements ArmorMaterial
{
    private static final int[] DMG_REDUCTION = new int[]{2, 5, 6, 2};
    private static final int[] MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};

    public int getDurabilityForType(ArmorItem.Type type) {
        return 24 * MAX_DAMAGE_ARRAY[type.getSlot().getIndex()];
    }

    public int getDefenseForType(ArmorItem.Type type) {
        return DMG_REDUCTION[type.getSlot().getIndex()];
    }

    public int getEnchantmentValue() {
        return 9;
    }

    public SoundEvent getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_IRON;
    }

    public Ingredient getRepairIngredient() {
        return Ingredient.of(PneumaticCraftTags.Items.INGOTS_COMPRESSED_IRON);
    }

    public String getName() {
        return "pneumaticcraft:compressed_iron";
    }

    public float getToughness() {
        return 1.0f;
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }
}

