/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DrillBitItem
extends Item {
    private final DrillBitType type;

    public DrillBitItem(DrillBitType type) {
        super(ModItems.defaultProps().stacksTo(1));
        this.type = type;
    }

    public DrillBitType getType() {
        return this.type;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.drillBit.tier", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)this.getType().tier.toString()).withStyle(ChatFormatting.GOLD)));
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.drillBit.blocks", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)Integer.toString(this.getType().getBestDigType().getBlocksDug())).withStyle(ChatFormatting.GOLD)));
        tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.drillBit.speed", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)Integer.toString(this.getType().baseEfficiency)).withStyle(ChatFormatting.GOLD)));
    }

    public static enum DrillBitType {
        NONE("none", null, (Tier)Tiers.WOOD, 0, 1, 0),
        IRON("iron", () -> ModItems.IRON_DRILL_BIT, (Tier)Tiers.IRON, -2565928, 6, 1),
        COMPRESSED_IRON("compressed_iron", () -> ModItems.COMPRESSED_IRON_DRILL_BIT, (Tier)Tiers.IRON, -11712442, 7, 2),
        DIAMOND("diamond", () -> ModItems.DIAMOND_DRILL_BIT, (Tier)Tiers.DIAMOND, -11866663, 8, 3),
        NETHERITE("netherite", () -> ModItems.NETHERITE_DRILL_BIT, (Tier)Tiers.NETHERITE, -13555414, 9, 4);

        private final String name;
        private final Supplier<Supplier<? extends DrillBitItem>> itemSupplier;
        private final Tier tier;
        private final int tint;
        private final int baseEfficiency;
        private final int bitQuality;

        private DrillBitType(String name, Supplier<Supplier<? extends DrillBitItem>> itemSupplier, Tier tier, int tint, int baseEfficiency, int bitQuality) {
            this.name = name;
            this.itemSupplier = itemSupplier;
            this.tier = tier;
            this.tint = tint;
            this.baseEfficiency = baseEfficiency;
            this.bitQuality = bitQuality;
        }

        public Tier getTier() {
            return this.tier;
        }

        public int getTint() {
            return this.tint;
        }

        public int getBitQuality() {
            return this.bitQuality;
        }

        public String getRegistryName() {
            return "drill_bit_" + this.name;
        }

        public int getBaseEfficiency() {
            return this.baseEfficiency;
        }

        public ItemStack asItemStack() {
            return this.itemSupplier == null ? ItemStack.EMPTY : new ItemStack((ItemLike)this.itemSupplier.get().get());
        }

        public JackHammerItem.DigMode getBestDigType() {
            for (int i = JackHammerItem.DigMode.values().length - 1; i >= 0; --i) {
                JackHammerItem.DigMode digMode = JackHammerItem.DigMode.values()[i];
                if (digMode.getBitType().getBitQuality() > this.getBitQuality()) continue;
                return digMode;
            }
            return JackHammerItem.DigMode.MODE_1X1;
        }
    }
}

