/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.common.block.entity.processing.UVLightBoxBlockEntity;
import me.desht.pneumaticcraft.common.item.CreativeTabStackProvider;
import me.desht.pneumaticcraft.common.item.NonDespawningItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import org.apache.commons.lang3.Validate;

public class EmptyPCBItem
extends NonDespawningItem
implements ICustomDurabilityBar,
CreativeTabStackProvider {
    private static final String NBT_ETCH_PROGRESS = "pneumaticcraft:etch_progress";

    @Override
    public void appendHoverText(ItemStack stack, Level player, List<Component> infoList, TooltipFlag par4) {
        super.appendHoverText(stack, player, infoList, par4);
        int uvProgress = UVLightBoxBlockEntity.getExposureProgress(stack);
        int etchProgress = EmptyPCBItem.getEtchProgress(stack);
        if (etchProgress > 0) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.uvLightBox.etchProgress", etchProgress));
        }
        infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.uvLightBox.successChance", uvProgress));
        if (uvProgress < 100 && etchProgress == 0) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.uvLightBox.putInLightBox", new Object[0]).withStyle(ChatFormatting.GRAY));
        }
        if (uvProgress > 0) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.uvLightBox.putInAcid", new Object[0]).withStyle(ChatFormatting.GRAY));
        }
    }

    public static int getEtchProgress(ItemStack stack) {
        return stack.hasTag() ? Objects.requireNonNull(stack.getTag()).getInt(NBT_ETCH_PROGRESS) : 0;
    }

    public static void setEtchProgress(ItemStack stack, int progress) {
        Validate.isTrue((progress >= 0 && progress <= 100 ? 1 : 0) != 0);
        stack.getOrCreateTag().putInt(NBT_ETCH_PROGRESS, progress);
    }

    public boolean isBarVisible(ItemStack pStack) {
        return true;
    }

    public int getBarWidth(ItemStack pStack) {
        int progress = UVLightBoxBlockEntity.getExposureProgress(pStack);
        return Math.round((float)progress / 100.0f * 13.0f);
    }

    public int getBarColor(ItemStack pStack) {
        int progress = UVLightBoxBlockEntity.getExposureProgress(pStack);
        return progress * 2 << 16 | 0xFF;
    }

    @Override
    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        super.onEntityItemUpdate(stack, entityItem);
        if (entityItem.level().getFluidState(entityItem.blockPosition()).getType().is(PneumaticCraftTags.Fluids.ETCHING_ACID)) {
            int etchProgress;
            if (!stack.hasTag()) {
                stack.setTag(new CompoundTag());
            }
            if ((etchProgress = EmptyPCBItem.getEtchProgress(stack)) < 100) {
                if (entityItem.tickCount % 60 == 0) {
                    EmptyPCBItem.setEtchProgress(stack, etchProgress + 1);
                }
                Level world = entityItem.getCommandSenderWorld();
                if (world.random.nextInt(15) == 0) {
                    double x = entityItem.getX() + world.random.nextDouble() * 0.3 - 0.15;
                    double y = entityItem.getY() - 0.15;
                    double z = entityItem.getZ() + world.random.nextDouble() * 0.3 - 0.15;
                    world.addParticle((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 0.0, 0.05, 0.0);
                }
            } else if (!entityItem.level().isClientSide) {
                int successCount = 0;
                int failedCount = 0;
                int uvProgress = UVLightBoxBlockEntity.getExposureProgress(stack);
                for (int i = 0; i < stack.getCount(); ++i) {
                    if (entityItem.level().random.nextInt(100) <= uvProgress) {
                        ++successCount;
                        continue;
                    }
                    ++failedCount;
                }
                ItemStack successStack = new ItemStack(successCount == 0 ? (ItemLike)ModItems.FAILED_PCB.get() : (ItemLike)ModItems.UNASSEMBLED_PCB.get(), successCount == 0 ? failedCount : successCount);
                entityItem.setItem(successStack);
                if (successCount > 0 && failedCount > 0) {
                    ItemStack failedStack = new ItemStack((ItemLike)ModItems.FAILED_PCB.get(), failedCount);
                    entityItem.level().addFreshEntity((Entity)new ItemEntity(entityItem.level(), entityItem.getX(), entityItem.getY(), entityItem.getZ(), failedStack));
                }
            }
        }
        return false;
    }

    @Override
    public boolean shouldShowCustomDurabilityBar(ItemStack stack) {
        return EmptyPCBItem.getEtchProgress(stack) > 0;
    }

    @Override
    public int getCustomDurabilityColour(ItemStack stack) {
        return MapColor.EMERALD.col;
    }

    @Override
    public float getCustomDurability(ItemStack stack) {
        return (float)EmptyPCBItem.getEtchProgress(stack) / 100.0f;
    }

    @Override
    public boolean isShowingOtherBar(ItemStack stack) {
        return true;
    }

    @Override
    public Stream<ItemStack> getStacksForItem() {
        ItemStack stack = new ItemStack((ItemLike)this);
        ItemStack stack2 = UVLightBoxBlockEntity.setExposureProgress(stack.copy(), 100);
        return Stream.of(stack, stack2);
    }
}

