/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GPSAreaToolScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.item.IGPSToolSync;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.Validate;

public class GPSAreaToolItem
extends Item
implements IPositionProvider,
IGPSToolSync {
    public GPSAreaToolItem() {
        super(ModItems.defaultProps());
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getPlayer() != null) {
            GPSAreaToolItem.setGPSPosAndNotify(ctx.getPlayer(), ctx.getHand(), ctx.getClickedPos(), 0);
            ctx.getPlayer().playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            GPSAreaToolScreen.showGUI(stack, handIn, 0);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public static void setGPSPosAndNotify(Player player, ItemStack stack, BlockPos pos, int index) {
        GPSAreaToolItem.setGPSLocation(player, stack, pos, null, index, true);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            player.displayClientMessage((Component)Component.literal((String)(ChatFormatting.AQUA + String.format("[%s] ", stack.getDisplayName().getString()))).append(GPSAreaToolItem.getMessageText(player.level(), pos, index)), false);
            sp.connection.send((Packet)new ClientboundSetCarriedItemPacket(player.getInventory().selected));
        }
    }

    public static void setGPSPosAndNotify(Player player, InteractionHand hand, BlockPos pos, int index) {
        GPSAreaToolItem.setGPSPosAndNotify(player, player.getItemInHand(hand), pos, index);
    }

    private static Component getMessageText(Level worldIn, BlockPos pos, int index) {
        Component translated = PneumaticCraftUtils.getBlockNameAt(worldIn, pos);
        MutableComponent blockName = worldIn.isLoaded(pos) ? Component.literal((String)" (").append(translated).append(")") : Component.empty().plainCopy();
        String str = String.format("P%d%s: [%d, %d, %d]", index + 1, ChatFormatting.YELLOW, pos.getX(), pos.getY(), pos.getZ());
        return Component.literal((String)str).withStyle(index == 0 ? ChatFormatting.RED : ChatFormatting.GREEN).append((Component)blockName.withStyle(ChatFormatting.GREEN));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level worldIn, List<Component> infoList, TooltipFlag par4) {
        super.appendHoverText(stack, worldIn, infoList, par4);
        if (worldIn != null) {
            ClientUtils.addGuiContextSensitiveTooltip(stack, infoList);
            int n = infoList.size();
            ProgWidgetArea area = GPSAreaToolItem.getArea(ClientUtils.getClientPlayer(), stack);
            for (int index = 0; index < 2; ++index) {
                int i = index;
                GPSAreaToolItem.getGPSLocation(ClientUtils.getClientPlayer(), stack, index).ifPresent(pos -> infoList.add(GPSAreaToolItem.getMessageText(worldIn, pos, i)));
                String varName = area.getVarName(index);
                if (varName.isEmpty()) continue;
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gpsTool.variable", varName));
            }
            if (infoList.size() - n >= 2) {
                area.addAreaTypeTooltip(infoList);
            }
        }
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean heldItem) {
        if (!world.isClientSide && entity instanceof Player) {
            Player p = (Player)entity;
            ProgWidgetArea area = GPSAreaToolItem.getArea(p, stack);
            for (int index = 0; index < 2; ++index) {
                BlockPos pos;
                BlockPos curPos;
                String varName = area.getVarName(index);
                if (varName.isEmpty() || (curPos = area.getPos(index).orElse(PneumaticCraftUtils.invalidPos())).equals((Object)(pos = GlobalVariableHelper.getPos(entity.getUUID(), varName, PneumaticCraftUtils.invalidPos())))) continue;
                GPSAreaToolItem.setGPSLocation(p, stack, pos, area, index, false);
            }
        }
    }

    @Nonnull
    public static ProgWidgetArea getArea(UUID playerId, ItemStack stack) {
        Validate.isTrue((boolean)(stack.getItem() instanceof GPSAreaToolItem));
        ProgWidgetArea area = new ProgWidgetArea();
        if (stack.hasTag()) {
            area.setVariableProvider(GlobalVariableHelper.getVariableProvider(), playerId);
            area.readFromNBT(stack.getTag());
        }
        return area;
    }

    public static ProgWidgetArea getArea(Player player, ItemStack stack) {
        return GPSAreaToolItem.getArea(player.getUUID(), stack);
    }

    public static Optional<BlockPos> getGPSLocation(Player player, ItemStack gpsTool, int index) {
        Validate.isTrue((index == 0 || index == 1 ? 1 : 0) != 0, (String)"index must be 0 or 1!", (Object[])new Object[0]);
        ProgWidgetArea area = GPSAreaToolItem.getArea(player, gpsTool);
        Optional<BlockPos> pos = area.getPos(index);
        String var = area.getVarName(index);
        if (!var.isEmpty() && !player.level().isClientSide) {
            BlockPos newPos = GlobalVariableHelper.getPos(player.getUUID(), var);
            if (pos.isEmpty() || !pos.get().equals((Object)newPos)) {
                area.setPos(index, newPos);
                area.writeToNBT(gpsTool.getOrCreateTag());
            }
            return Optional.of(newPos);
        }
        return pos;
    }

    private static void setGPSLocation(Player player, ItemStack gpsTool, BlockPos pos, ProgWidgetArea area, int index, boolean updateVar) {
        String varName;
        if (area == null) {
            area = GPSAreaToolItem.getArea(player, gpsTool);
        }
        area.setPos(index, pos);
        area.writeToNBT(gpsTool.getOrCreateTag());
        if (updateVar && !(varName = area.getVarName(index)).isEmpty()) {
            GlobalVariableHelper.setPos(player.getUUID(), varName, pos);
        }
    }

    public static void setVariable(Player player, ItemStack gpsTool, String variable, int index) {
        ProgWidgetArea area = GPSAreaToolItem.getArea(player, gpsTool);
        area.setVarName(index, variable);
        area.writeToNBT(gpsTool.getOrCreateTag());
    }

    public static String getVariable(Player player, ItemStack gpsTool, int index) {
        return GPSAreaToolItem.getArea(player, gpsTool).getVarName(index);
    }

    @Override
    public void syncVariables(ServerPlayer player, ItemStack stack) {
        ProgWidgetArea area = GPSAreaToolItem.getArea((Player)player, stack);
        String v1 = area.getVarName(0);
        String v2 = area.getVarName(1);
        if (GlobalVariableHelper.hasPrefix(v1)) {
            PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(player, v1);
        }
        if (GlobalVariableHelper.hasPrefix(v2)) {
            PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(player, v2);
        }
    }

    @Override
    public List<BlockPos> getStoredPositions(UUID playerId, @Nonnull ItemStack stack) {
        HashSet<BlockPos> posSet = new HashSet<BlockPos>();
        GPSAreaToolItem.getArea(playerId, stack).getArea(posSet);
        return new ArrayList<BlockPos>(posSet);
    }

    @Override
    public List<BlockPos> getRawStoredPositions(Player player, ItemStack stack) {
        ProgWidgetArea area = GPSAreaToolItem.getArea(player, stack);
        return ImmutableList.of((Object)area.getPos(0).orElse(BlockPos.ZERO), (Object)area.getPos(1).orElse(BlockPos.ZERO));
    }

    @Override
    public int getRenderColor(int index) {
        return 0x60FFFF00;
    }

    @Override
    public boolean disableDepthTest() {
        return false;
    }

    @Override
    public void syncFromClient(Player player, ItemStack stack, int index, BlockPos pos, String varName) {
        GPSAreaToolItem.setVariable(player, stack, varName, index);
        GPSAreaToolItem.setGPSPosAndNotify(player, stack, pos, index);
        if (!varName.isEmpty()) {
            GlobalVariableHelper.setPos(player.getUUID(), varName, pos);
        }
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getItemStack().getItem() == ModItems.GPS_AREA_TOOL.get()) {
                Optional<BlockPos> optPos = GPSAreaToolItem.getGPSLocation(event.getEntity(), event.getItemStack(), 1);
                if (!event.getPos().equals(optPos.orElse(null))) {
                    event.getEntity().playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
                    GPSAreaToolItem.setGPSPosAndNotify(event.getEntity(), event.getHand(), event.getPos(), 1);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
            if (event.getItemStack().getItem() == ModItems.GPS_AREA_TOOL.get()) {
                GPSAreaToolScreen.showGUI(event.getItemStack(), event.getHand(), 1);
            }
        }
    }
}

