/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GPSToolScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.IGPSToolSync;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class GPSToolItem
extends Item
implements IPositionProvider,
IGPSToolSync {
    public GPSToolItem() {
        super(ModItems.defaultProps());
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        if (ctx.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        GPSToolItem.setGPSLocation(ctx.getPlayer().getUUID(), ctx.getPlayer().getItemInHand(ctx.getHand()), pos);
        if (!ctx.getLevel().isClientSide) {
            ctx.getPlayer().displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.gps_tool.targetSet", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(ChatFormatting.GREEN), false);
        }
        ctx.getPlayer().playSound((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.5f);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            GPSToolScreen.showGUI(stack, handIn, GPSToolItem.getGPSLocation(playerIn.getUUID(), stack).orElse(playerIn.blockPosition()));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Level worldIn, List<Component> infoList, TooltipFlag par4) {
        super.appendHoverText(stack, worldIn, infoList, par4);
        if (worldIn != null) {
            ClientUtils.addGuiContextSensitiveTooltip(stack, infoList);
            GPSToolItem.getGPSLocation(ClientUtils.getClientPlayer().getUUID(), stack).ifPresent(pos -> {
                MutableComponent translated = Component.translatable((String)worldIn.getBlockState(pos).getBlock().getDescriptionId());
                MutableComponent blockName = worldIn.isLoaded(pos) ? Component.literal((String)" (").append((Component)translated).append(")") : Component.empty().plainCopy();
                String str = String.format("[%d, %d, %d]", pos.getX(), pos.getY(), pos.getZ());
                infoList.add((Component)Component.literal((String)str).withStyle(ChatFormatting.YELLOW).append((Component)blockName.withStyle(ChatFormatting.GREEN)));
            });
            String varName = GPSToolItem.getVariable(stack);
            if (!varName.isEmpty()) {
                infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gpsTool.variable", varName));
            }
        }
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean heldItem) {
        String var = GPSToolItem.getVariable(stack);
        if (!var.isEmpty() && !world.isClientSide && entity instanceof Player) {
            GPSToolItem.getGPSLocation(entity.getUUID(), stack).ifPresent(curPos -> {
                BlockPos varPos = GlobalVariableHelper.getPos(entity.getUUID(), var, PneumaticCraftUtils.invalidPos());
                if (!varPos.equals(curPos)) {
                    GPSToolItem.setGPSLocation(entity.getUUID(), stack, varPos, false);
                }
            });
        }
    }

    @Nonnull
    public static Optional<BlockPos> getGPSLocation(ItemStack stack) {
        return GPSToolItem.getGPSLocation(null, stack);
    }

    @Nonnull
    public static Optional<BlockPos> getGPSLocation(UUID playerId, ItemStack gpsTool) {
        CompoundTag compound = gpsTool.getTag();
        if (gpsTool.getItem() == ModItems.GPS_TOOL.get() && compound != null) {
            BlockPos pos;
            BlockPos curPos = compound.contains("Pos") ? NbtUtils.readBlockPos((CompoundTag)compound.getCompound("Pos")) : PneumaticCraftUtils.invalidPos();
            String var = GPSToolItem.getVariable(gpsTool);
            if (!var.isEmpty() && (pos = GlobalVariableHelper.getPos(playerId, var)) != null && !curPos.equals((Object)pos)) {
                GPSToolItem.setGPSLocation(playerId, gpsTool, pos, false);
            }
            return PneumaticCraftUtils.isValidPos(curPos) ? Optional.of(curPos) : Optional.empty();
        }
        return Optional.empty();
    }

    public static void setGPSLocation(UUID playerId, ItemStack gpsTool, BlockPos pos) {
        GPSToolItem.setGPSLocation(playerId, gpsTool, pos, true);
    }

    public static void setGPSLocation(UUID playerId, ItemStack gpsTool, BlockPos pos, boolean updateVarManager) {
        String var;
        NBTUtils.setCompoundTag(gpsTool, "Pos", (Tag)NbtUtils.writeBlockPos((BlockPos)pos));
        if (updateVarManager && !(var = GPSToolItem.getVariable(gpsTool)).isEmpty()) {
            GlobalVariableHelper.setPos(playerId, var, pos);
        }
    }

    public static void setVariable(ItemStack gpsTool, String variable) {
        NBTUtils.setString(gpsTool, "variable", variable);
    }

    public static String getVariable(ItemStack gpsTool) {
        return gpsTool.hasTag() ? Objects.requireNonNull(gpsTool.getTag()).getString("variable") : "";
    }

    @Override
    public List<BlockPos> getStoredPositions(UUID playerId, @Nonnull ItemStack stack) {
        return GPSToolItem.getGPSLocation(playerId, stack).map(Collections::singletonList).orElse(Collections.emptyList());
    }

    @Override
    public int getRenderColor(int index) {
        return -1862271232;
    }

    @Override
    public void syncVariables(ServerPlayer player, ItemStack stack) {
        String varName = GPSToolItem.getVariable(stack);
        if (GlobalVariableHelper.hasPrefix(varName)) {
            PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(player, varName);
        }
    }

    @Override
    public void syncFromClient(Player player, ItemStack stack, int index, BlockPos pos, String varName) {
        GPSToolItem.setVariable(stack, varName);
        GPSToolItem.setGPSLocation(player.getUUID(), stack, pos);
        if (!varName.isEmpty()) {
            GlobalVariableHelper.setPos(player.getUUID(), varName, pos);
        }
    }
}

