/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.inventory.JackhammerSetupMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.DrillBitItem;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.TierSortingRegistry;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class JackHammerItem
extends PressurizableItem
implements IChargeableContainerProvider,
ColorHandlers.ITintableItem,
IShiftScrollable {
    private static final float[] SPEED_MULT = new float[]{1.0f, 2.0f, 2.4142137f, 2.732051f, 3.0f, 3.236068f, 3.4494898f, 3.6457512f, 3.828427f, 4.0f, 4.1622777f};
    private static final String NBT_DIG_MODE = "DigMode";
    private static long lastModeSwitchTime;

    public JackHammerItem() {
        super(ModItems.toolProps(), 120000, 12000);
    }

    public static long getLastModeSwitchTime() {
        return lastModeSwitchTime;
    }

    public static DrillBitHandler getDrillBitHandler(ItemStack stack) {
        if (stack.getItem() instanceof JackHammerItem) {
            return new DrillBitHandler(stack);
        }
        return null;
    }

    public static EnchantmentHandler getEnchantmentHandler(ItemStack stack) {
        if (stack.getItem() instanceof JackHammerItem) {
            return new EnchantmentHandler(stack);
        }
        return null;
    }

    public DrillBitItem.DrillBitType getDrillBit(ItemStack stack) {
        DrillBitItem.DrillBitType drillBitType;
        DrillBitHandler handler = new DrillBitHandler(stack);
        Item item = handler.getStackInSlot(0).getItem();
        if (item instanceof DrillBitItem) {
            DrillBitItem bit = (DrillBitItem)item;
            drillBitType = bit.getType();
        } else {
            drillBitType = DrillBitItem.DrillBitType.NONE;
        }
        return drillBitType;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return TierSortingRegistry.isCorrectTierForDrops((Tier)this.getDrillBit(stack).getTier(), (BlockState)state);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        DrillBitItem.DrillBitType bitType = this.getDrillBit(stack);
        int speed = bitType == DrillBitItem.DrillBitType.NONE ? 0 : UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.SPEED.get());
        return (float)this.getAir(stack) > 0.0f ? (float)bitType.getBaseEfficiency() * SPEED_MULT[speed] : 1.0f;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, final InteractionHand handIn) {
        final ItemStack stack = playerIn.getItemInHand(handIn);
        if (!playerIn.isCrouching() || stack.getCount() != 1) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)playerIn;
            sp.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return stack.getHoverName();
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                    return new JackhammerSetupMenu(windowId, inv, handIn);
                }
            }, buf -> AbstractPneumaticCraftMenu.putHand(buf, handIn));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return this.getDrillBit(stack) != DrillBitItem.DrillBitType.NONE && (float)this.getAir(stack) > 0.0f;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        MutableBoolean didWork = new MutableBoolean(false);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Level level = serverPlayer.getCommandSenderWorld();
            HitResult hitResult = RayTraceUtils.getEntityLookedObject((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                PNCCapabilities.getAirHandler(itemstack).ifPresent(airHandler -> {
                    float usage;
                    float air;
                    DigMode digMode = JackHammerItem.getDigMode(itemstack);
                    IntList upgrades = UpgradableItemUtils.getUpgradeList(itemstack, ModUpgrades.SPEED.get(), ModUpgrades.MAGNET.get());
                    int speed = upgrades.getInt(0);
                    boolean magnet = upgrades.getInt(1) > 0 && digMode.isVeinMining();
                    DrillBitItem.DrillBitType bitType = this.getDrillBit(itemstack);
                    if (TierSortingRegistry.getTiersLowerThan((Tier)digMode.getBitType().getTier()).contains(bitType.getTier())) {
                        digMode = DigMode.MODE_1X1;
                    }
                    Set<BlockPos> brokenPos = JackHammerItem.getBreakPositions(level, pos, blockHitResult.getDirection(), player, digMode);
                    float air0 = air = (float)airHandler.getAir();
                    float f = usage = player.isCreative() ? 0.0f : 50.0f * SPEED_MULT[speed];
                    if (magnet) {
                        usage *= 1.1f;
                    }
                    if (air >= usage) {
                        didWork.setTrue();
                        air -= usage;
                        for (BlockPos pos1 : brokenPos) {
                            int exp;
                            if (air < usage) break;
                            BlockState state1 = level.getBlockState(pos1);
                            if (state1.getDestroySpeed((BlockGetter)level, pos1) < 0.0f || (exp = CommonHooks.onBlockBreakEvent((Level)serverPlayer.level(), (GameType)serverPlayer.gameMode.getGameModeForPlayer(), (ServerPlayer)serverPlayer, (BlockPos)pos1)) == -1 || level.getBlockEntity(pos1) != null) continue;
                            Block block = state1.getBlock();
                            boolean removed = state1.onDestroyedByPlayer(level, pos1, player, true, level.getFluidState(pos1));
                            if (!removed) continue;
                            block.destroy((LevelAccessor)level, pos1, state1);
                            if (magnet) {
                                JackHammerItem.magnetHarvest(block, level, player, pos, pos1, state1, itemstack);
                            } else {
                                block.playerDestroy(level, player, pos1, state1, null, itemstack);
                            }
                            if (exp > 0 && level instanceof ServerLevel) {
                                block.popExperience((ServerLevel)level, magnet ? pos : pos1, exp);
                            }
                            air -= usage;
                            player.awardStat(Stats.ITEM_USED.get((Object)this));
                        }
                        if (air != air0 && !player.isCreative()) {
                            airHandler.addAir((int)(air - air0));
                        }
                    }
                });
            }
        }
        return !didWork.booleanValue();
    }

    private static void magnetHarvest(Block block, Level level, Player player, BlockPos pos0, BlockPos pos, BlockState state, ItemStack stack) {
        player.awardStat(Stats.BLOCK_MINED.get((Object)block));
        player.causeFoodExhaustion(0.005f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)player, (ItemStack)stack).forEach(stackToSpawn -> Block.popResource((Level)level, (BlockPos)pos0, (ItemStack)stackToSpawn));
            state.spawnAfterBreak(serverLevel, pos, stack, true);
        }
    }

    public static Set<BlockPos> getBreakPositions(Level world, BlockPos pos, Direction dir, Player player, DigMode digMode) {
        if (player.isShiftKeyDown()) {
            return new HashSet<BlockPos>();
        }
        if (digMode.isVeinMining()) {
            return new HashSet<BlockPos>(JackHammerItem.getVeinPositions(world, pos, digMode));
        }
        Direction playerHoriz = player.getDirection();
        HashSet<BlockPos> res = new HashSet<BlockPos>();
        if (digMode.atLeast(DigMode.MODE_1X2)) {
            res.add(dir.getAxis() == Direction.Axis.Y ? pos.relative(playerHoriz) : pos.below());
        }
        if (digMode.atLeast(DigMode.MODE_1X3)) {
            res.add(dir.getAxis() == Direction.Axis.Y ? pos.relative(playerHoriz.getOpposite()) : pos.above());
        }
        if (digMode.atLeast(DigMode.MODE_3X3_CROSS)) {
            switch (dir.getAxis()) {
                case X: {
                    res.add(pos.north());
                    res.add(pos.south());
                    res.add(pos.above());
                    res.add(pos.below());
                    break;
                }
                case Y: {
                    res.add(pos.north());
                    res.add(pos.south());
                    res.add(pos.west());
                    res.add(pos.east());
                    break;
                }
                case Z: {
                    res.add(pos.above());
                    res.add(pos.below());
                    res.add(pos.west());
                    res.add(pos.east());
                }
            }
        }
        if (digMode.atLeast(DigMode.MODE_3X3_FULL)) {
            switch (dir.getAxis()) {
                case X: {
                    res.add(pos.above().north());
                    res.add(pos.above().south());
                    res.add(pos.below().north());
                    res.add(pos.below().south());
                    break;
                }
                case Y: {
                    res.add(pos.north().east());
                    res.add(pos.north().west());
                    res.add(pos.south().east());
                    res.add(pos.south().west());
                    break;
                }
                case Z: {
                    res.add(pos.above().east());
                    res.add(pos.above().west());
                    res.add(pos.below().east());
                    res.add(pos.below().west());
                }
            }
        }
        res.remove(pos);
        return res;
    }

    private static List<BlockPos> getVeinPositions(Level world, BlockPos startPos, DigMode mode) {
        BlockState state = world.getBlockState(startPos);
        if (!mode.okToVeinMine(state)) {
            return Collections.emptyList();
        }
        int maxRange = (Integer)ConfigHelper.common().jackhammer.maxVeinMinerRange.get();
        int maxRangeSq = maxRange * maxRange;
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        found.add(startPos);
        ObjectOpenHashSet checked = new ObjectOpenHashSet();
        Block startBlock = state.getBlock();
        int maxBlocks = mode.getBlocksDug();
        for (int i = 0; i < found.size(); ++i) {
            BlockPos blockPos = (BlockPos)found.get(i);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-1, -1, -1), (BlockPos)blockPos.offset(1, 1, 1))) {
                if (checked.contains(pos) || mode == DigMode.MODE_VEIN_PLUS && startPos.distSqr((Vec3i)pos) > (double)maxRangeSq || !world.isLoaded(pos) || startBlock != world.getBlockState(pos).getBlock()) continue;
                BlockPos pos1 = pos.immutable();
                found.add(pos1);
                checked.add(pos1);
                if (found.size() <= maxBlocks) continue;
                return found;
            }
        }
        return found;
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, ModMenuTypes.CHARGING_JACKHAMMER.get());
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return this.getDrillBit(stack).getTint();
        }
        return -1;
    }

    public static DigMode getDigMode(ItemStack stack) {
        if (stack.getItem() instanceof JackHammerItem && stack.hasTag()) {
            try {
                return Objects.requireNonNull(stack.getTag()).contains(NBT_DIG_MODE) ? DigMode.valueOf(stack.getTag().getString(NBT_DIG_MODE)) : DigMode.MODE_1X1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return DigMode.MODE_1X1;
    }

    public static void setDigMode(ItemStack stack, DigMode mode) {
        stack.getOrCreateTag().putString(NBT_DIG_MODE, mode.toString());
    }

    public static DigMode cycleDigMode(ItemStack stack, boolean forward) {
        if (stack.getItem() instanceof JackHammerItem) {
            DigMode currentMode;
            DrillBitItem.DrillBitType ourBit = ((JackHammerItem)stack.getItem()).getDrillBit(stack);
            DigMode newMode = currentMode = JackHammerItem.getDigMode(stack);
            if (forward) {
                newMode = currentMode == DigMode.MODE_VEIN_PLUS ? DigMode.MODE_1X1 : ((newMode = DigMode.values()[currentMode.ordinal() + 1]).getBitType().getBitQuality() <= ourBit.getBitQuality() ? newMode : DigMode.MODE_1X1);
            } else if (currentMode == DigMode.MODE_1X1) {
                for (int i = DigMode.values().length - 1; i >= 0; --i) {
                    if (DigMode.values()[i].getBitType().getBitQuality() > ourBit.getBitQuality()) continue;
                    newMode = DigMode.values()[i];
                    break;
                }
            } else {
                newMode = DigMode.values()[currentMode.ordinal() - 1];
            }
            JackHammerItem.setDigMode(stack, newMode);
            return newMode;
        }
        return null;
    }

    @Override
    public void onShiftScrolled(Player player, boolean forward, InteractionHand hand) {
        if (!player.level().isClientSide) {
            DigMode newMode = JackHammerItem.cycleDigMode(player.getItemInHand(hand), forward);
            if (newMode != null) {
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.jackhammer.mode", new Object[0]).append((Component)PneumaticCraftUtils.xlate(newMode.getTranslationKey(), new Object[0]).withStyle(ChatFormatting.YELLOW)), true);
            }
        } else {
            lastModeSwitchTime = player.level().getGameTime();
        }
    }

    public static class DrillBitHandler
    extends BaseItemStackHandler {
        private static final String NBT_DRILL_BIT = "DrillBit";
        private final ItemStack jackhammerStack;

        public DrillBitHandler(ItemStack jackhammerStack) {
            super(1);
            this.jackhammerStack = jackhammerStack;
            if (jackhammerStack.hasTag() && Objects.requireNonNull(jackhammerStack.getTag()).contains(NBT_DRILL_BIT, 8)) {
                String name = jackhammerStack.getTag().getString(NBT_DRILL_BIT);
                try {
                    DrillBitItem.DrillBitType type = DrillBitItem.DrillBitType.valueOf(name);
                    this.setStackInSlot(0, type.asItemStack());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || itemStack.getItem() instanceof DrillBitItem;
        }

        public void save() {
            ItemStack bitStack = this.getStackInSlot(0);
            Item item = bitStack.getItem();
            if (item instanceof DrillBitItem) {
                DrillBitItem bit = (DrillBitItem)item;
                NBTUtils.setString(this.jackhammerStack, NBT_DRILL_BIT, bit.getType().toString());
            } else {
                NBTUtils.setString(this.jackhammerStack, NBT_DRILL_BIT, DrillBitItem.DrillBitType.NONE.toString());
            }
        }
    }

    public static class EnchantmentHandler
    extends BaseItemStackHandler {
        private final ItemStack jackhammerStack;

        public EnchantmentHandler(ItemStack jackhammerStack) {
            super(1);
            this.jackhammerStack = jackhammerStack;
            Map ench = EnchantmentHelper.getEnchantments((ItemStack)jackhammerStack);
            for (Map.Entry map : ench.entrySet()) {
                if (map.getKey() != Enchantments.SILK_TOUCH && map.getKey() != Enchantments.BLOCK_FORTUNE) continue;
                ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                EnchantmentHelper.setEnchantments(Collections.singletonMap((Enchantment)map.getKey(), (Integer)map.getValue()), (ItemStack)book);
                this.setStackInSlot(0, book);
                break;
            }
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.isEmpty() || EnchantmentHandler.validateBook(stack);
        }

        public void save() {
            ItemStack bookStack = this.getStackInSlot(0);
            Map currentEnchants = EnchantmentHelper.getEnchantments((ItemStack)this.jackhammerStack);
            currentEnchants.remove(Enchantments.SILK_TOUCH);
            currentEnchants.remove(Enchantments.BLOCK_FORTUNE);
            if (EnchantmentHandler.validateBook(bookStack)) {
                currentEnchants.putAll(EnchantmentHelper.getEnchantments((ItemStack)bookStack));
            }
            EnchantmentHelper.setEnchantments((Map)currentEnchants, (ItemStack)this.jackhammerStack);
        }

        public static boolean validateBook(ItemStack bookStack) {
            if (bookStack.getItem() == Items.ENCHANTED_BOOK) {
                Map ench = EnchantmentHelper.getEnchantments((ItemStack)bookStack);
                if (ench.size() != 1) {
                    return false;
                }
                return ench.containsKey(Enchantments.BLOCK_FORTUNE) || ench.containsKey(Enchantments.SILK_TOUCH);
            }
            return false;
        }
    }

    public static enum DigMode implements ITranslatableEnum
    {
        MODE_1X1("1x1", 1, DrillBitItem.DrillBitType.IRON),
        MODE_1X2("1x2", 2, DrillBitItem.DrillBitType.COMPRESSED_IRON),
        MODE_1X3("1x3", 3, DrillBitItem.DrillBitType.COMPRESSED_IRON),
        MODE_3X3_CROSS("3x3_cross", 5, DrillBitItem.DrillBitType.DIAMOND),
        MODE_VEIN("vein", 128, DrillBitItem.DrillBitType.DIAMOND),
        MODE_3X3_FULL("3x3_full", 9, DrillBitItem.DrillBitType.DIAMOND),
        MODE_VEIN_PLUS("vein_plus", 128, DrillBitItem.DrillBitType.NETHERITE);

        private final String name;
        private final int blocksDug;
        private final DrillBitItem.DrillBitType bitType;

        private DigMode(String name, int blocksDug, DrillBitItem.DrillBitType bitType) {
            this.name = name;
            this.blocksDug = blocksDug;
            this.bitType = bitType;
        }

        public String getName() {
            return this.name;
        }

        public DrillBitItem.DrillBitType getBitType() {
            return this.bitType;
        }

        public int getBlocksDug() {
            return this.blocksDug;
        }

        public ResourceLocation getGuiIcon() {
            return Textures.guiIconTexture("gui_" + this.name + ".png");
        }

        public boolean atLeast(DigMode type) {
            return type.ordinal() <= this.ordinal();
        }

        public boolean isVeinMining() {
            return this == MODE_VEIN || this == MODE_VEIN_PLUS;
        }

        public boolean okToVeinMine(BlockState state) {
            return switch (this) {
                case MODE_VEIN -> state.is(PneumaticCraftTags.Blocks.JACKHAMMER_ORES);
                case MODE_VEIN_PLUS -> true;
                default -> false;
            };
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.message.jackhammer.mode." + this.name;
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            JackHammerItem jackHammer;
            Player player = event.getEntity();
            ItemStack stack = player.getItemInHand(event.getHand());
            Item item = stack.getItem();
            if (item instanceof JackHammerItem && (float)(jackHammer = (JackHammerItem)item).getAir(stack) > 0.0f) {
                if (event.getLevel().isClientSide) {
                    MovingSounds.playMovingSound(MovingSounds.Sound.JACKHAMMER, event.getEntity(), new Object[0]);
                } else {
                    NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketPlayMovingSound(MovingSounds.Sound.JACKHAMMER, PacketPlayMovingSound.MovingSoundFocus.of((Entity)player)), (Entity)player);
                }
            }
        }
    }
}

