/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.desht.pneumaticcraft.client.gui.MicromissileScreen;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.MicromissileDefaults;
import me.desht.pneumaticcraft.common.entity.projectile.MicromissileEntity;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import org.apache.commons.lang3.Validate;

public class MicromissilesItem
extends Item {
    public static final String NBT_TOP_SPEED = "topSpeed";
    public static final String NBT_TURN_SPEED = "turnSpeed";
    public static final String NBT_DAMAGE = "damage";
    public static final String NBT_FILTER = "filter";
    public static final String NBT_PX = "px";
    public static final String NBT_PY = "py";
    public static final String NBT_FIRE_MODE = "fireMode";

    public MicromissilesItem() {
        super(ModItems.defaultProps().stacksTo(1).defaultDurability(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().micromissiles.missilePodSize.get();
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return toRepair.getItem() == this && repair.getItem() == Blocks.TNT.asItem();
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!NBTUtils.hasTag(stack, NBT_TOP_SPEED)) {
            stack.setTag(MicromissileDefaults.INSTANCE.getDefaults(playerIn).toNBT());
        }
        if (playerIn.isShiftKeyDown()) {
            if (worldIn.isClientSide) {
                MicromissileScreen.openGui(stack.getHoverName(), handIn);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        MicromissileEntity missile = new MicromissileEntity(worldIn, (LivingEntity)playerIn, stack);
        Vec3 newPos = missile.position().add(playerIn.getLookAngle().normalize());
        missile.setPos(newPos.x, newPos.y, newPos.z);
        missile.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, this.getInitialVelocity(stack), 0.0f);
        playerIn.getCooldowns().addCooldown((Item)this, ((Integer)ConfigHelper.common().micromissiles.launchCooldown.get()).intValue());
        if (!worldIn.isClientSide) {
            EntityHitResult ertr;
            HitResult res = RayTraceUtils.getMouseOverServer((LivingEntity)playerIn, 100.0);
            if (res instanceof EntityHitResult && missile.isValidTarget((ertr = (EntityHitResult)res).getEntity())) {
                missile.setTarget(ertr.getEntity());
            }
            worldIn.addFreshEntity((Entity)missile);
        }
        if (!playerIn.isCreative()) {
            stack.hurtAndBreak(1, (LivingEntity)playerIn, playerEntity -> {});
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private float getInitialVelocity(ItemStack stack) {
        if (stack.hasTag()) {
            CompoundTag tag = Objects.requireNonNull(stack.getTag());
            FireMode fireMode = FireMode.fromString(tag.getString(NBT_FIRE_MODE));
            if (fireMode == FireMode.SMART) {
                return Math.max(0.2f, tag.getFloat(NBT_TOP_SPEED) / 2.0f);
            }
            return 0.33333334f;
        }
        return 0.33333334f;
    }

    public void appendHoverText(ItemStack stack, Level worldIn, List<Component> curInfo, TooltipFlag extraInfo) {
        super.appendHoverText(stack, worldIn, curInfo, extraInfo);
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.remaining", new Object[0]).append((Component)Component.literal((String)Integer.toString(stack.getMaxDamage() - stack.getDamageValue())).withStyle(ChatFormatting.AQUA)));
        if (NBTUtils.hasTag(stack, NBT_TOP_SPEED)) {
            String filter;
            FireMode mode = MicromissilesItem.getFireMode(stack);
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.micromissile.firingMode", new Object[0]).append(": ").append((Component)PneumaticCraftUtils.xlate(mode.getTranslationKey(), new Object[0]).withStyle(ChatFormatting.AQUA)));
            if (mode == FireMode.SMART && !(filter = Objects.requireNonNull(stack.getTag()).getString(NBT_FILTER)).isEmpty()) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.sentryTurret.targetFilter", new Object[0]).append(": ").append(ChatFormatting.AQUA + filter));
            }
        }
        if (((Boolean)ConfigHelper.common().micromissiles.damageTerrain.get()).booleanValue()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainWarning", new Object[0]));
        } else {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainSafe", new Object[0]));
        }
    }

    public static void setEntityFilter(ItemStack stack, String filterString) {
        if (stack.getItem() instanceof MicromissilesItem) {
            stack.getOrCreateTag().putString(NBT_FILTER, filterString);
        }
    }

    public static FireMode getFireMode(ItemStack stack) {
        Validate.isTrue((boolean)(stack.getItem() instanceof MicromissilesItem));
        return stack.hasTag() ? FireMode.fromString(Objects.requireNonNull(stack.getTag()).getString(NBT_FIRE_MODE)) : FireMode.SMART;
    }

    public static enum FireMode implements ITranslatableEnum
    {
        SMART,
        DUMB;


        public static FireMode fromString(String mode) {
            try {
                return FireMode.valueOf(mode);
            }
            catch (IllegalArgumentException e) {
                return SMART;
            }
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.micromissile.mode." + this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public record Tooltip(ItemStack stack) implements TooltipComponent
    {
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onMissilesRepair(AnvilRepairEvent event) {
            if (event.getOutput().getItem() instanceof MicromissilesItem && event.getOutput().hasTag()) {
                event.getOutput().setRepairCost(0);
            }
        }
    }
}

