/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.mixin.accessors.ItemEntityAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class NonDespawningItem
extends Item {
    public NonDespawningItem() {
        super(ModItems.defaultProps());
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        if (!entityItem.level().isClientSide && ((ItemEntityAccess)entityItem).getAge() < entityItem.getItem().getEntityLifespan(entityItem.level()) - 1) {
            entityItem.setExtendedLifetime();
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level worldIn, List<Component> curInfo, TooltipFlag moreInfo) {
        super.appendHoverText(stack, worldIn, curInfo, moreInfo);
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.doesNotDespawn", new Object[0]));
    }
}

