/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.EnderVisorClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammableControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.entity.drone.AbstractDroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.entity.drone.ProgrammableControllerEntity;
import me.desht.pneumaticcraft.common.item.CompressedIronArmorMaterial;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.ElytraHandler;
import me.desht.pneumaticcraft.common.recipes.special.OneProbeCrafting;
import me.desht.pneumaticcraft.common.registry.ModAttachmentTypes;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class PneumaticArmorItem
extends ArmorItem
implements IChargeableContainerProvider,
IFOVModifierItem,
ICustomDurabilityBar,
IPressurizableItem,
DyeableLeatherItem,
ColorHandlers.ITintableItem {
    private static final UUID[] PNEUMATIC_ARMOR_MODIFIERS = new UUID[]{UUID.fromString("4a6bf01d-2e83-4b13-aaf0-a4c05958ea3c"), UUID.fromString("ad78a169-0409-47fb-8ca2-126b19196b56"), UUID.fromString("87bf456d-7360-407d-8592-5a2583eb948c"), UUID.fromString("e836e6c9-355e-49f2-87fc-331fadfdd642")};
    private static final ArmorMaterial PNEUMATIC_ARMOR_MATERIAL = new CompressedIronArmorMaterial(0.2f);
    private static final int[] ARMOR_VOLUMES = new int[]{12000, 12000, 28000, 12000};
    public static final String NBT_SEARCH_ITEM = "SearchStack";
    public static final String NBT_COORD_TRACKER = "CoordTracker";
    public static final String NBT_ENTITY_FILTER = "entityFilter";
    public static final String NBT_JUMP_BOOST = "jumpBoost";
    public static final String NBT_SPEED_BOOST = "speedBoost";
    public static final String NBT_BUILDER_MODE = "JetBootsBuilderMode";
    public static final String NBT_JET_BOOTS_POWER = "JetBootsPower";
    public static final String NBT_FLIGHT_STABILIZERS = "JetBootsStabilizers";
    public static final String NBT_HOVER = "Hover";
    public static final String NBT_SMART_HOVER = "SmartHover";
    public static final int DEFAULT_PRIMARY_COLOR = -6908266;
    public static final int DEFAULT_SECONDARY_COLOR = -4144960;
    public static final int DEFAULT_EYEPIECE_COLOR = -16733696;

    public PneumaticArmorItem(ArmorItem.Type equipmentSlotIn) {
        super(PNEUMATIC_ARMOR_MATERIAL, equipmentSlotIn, ModItems.defaultProps());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new EnderVisorClientHandler.PumpkinOverlay());
    }

    public static boolean isPlayerWearingAnyPneumaticArmor(Player player) {
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            if (!PneumaticArmorItem.isPneumaticArmorPiece(player, slot)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPneumaticArmorPiece(Player player, EquipmentSlot slot) {
        return player.getItemBySlot(slot).getItem() instanceof PneumaticArmorItem;
    }

    @Override
    public int getBaseVolume() {
        return ARMOR_VOLUMES[this.type.getSlot().getIndex()];
    }

    @Override
    public int getVolumeUpgrades(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.VOLUME.get());
    }

    @Override
    public int getAir(ItemStack stack) {
        return (Integer)stack.getData(ModAttachmentTypes.AIR.get());
    }

    @Override
    public float getMaxPressure() {
        return 10.0f;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        String s = slot == EquipmentSlot.LEGS ? "pneumaticcraft:textures/armor/pneumatic_2" : "pneumaticcraft:textures/armor/pneumatic_1";
        return type == null ? s + ".png" : s + "_" + type + ".png";
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.type == ArmorItem.Type.HELMET && worldIn != null) {
            this.addHelmetInformation(stack, worldIn, tooltip);
        }
    }

    private void addHelmetInformation(ItemStack stack, Level worldIn, List<Component> tooltip) {
        BlockPos pos;
        ItemStack searchStack;
        Item searchedItem;
        if (OneProbeCrafting.isOneProbeEnabled(stack)) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("gui.tooltip.item.pneumaticcraft.pneumatic_helmet.one_probe", new Object[0]).withStyle(ChatFormatting.BLUE));
        }
        if ((searchedItem = PneumaticArmorItem.getSearchedItem(stack)) != null && !(searchStack = new ItemStack((ItemLike)searchedItem)).isEmpty()) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.search", new Object[0]).append(": ").append(searchStack.getHoverName()).withStyle(ChatFormatting.YELLOW));
        }
        if ((pos = PneumaticArmorItem.getCoordTrackerPos(stack, worldIn)) != null) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.coordinate_tracker", new Object[0]).append(": ").append(PneumaticCraftUtils.posToString(pos)).withStyle(ChatFormatting.YELLOW));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return (Boolean)ConfigHelper.client().armor.showEnchantGlint.get() != false && super.isFoil(stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create((Multimap)super.getAttributeModifiers(equipmentSlot, stack));
        if (equipmentSlot == this.type.getSlot()) {
            int upgrades = UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.ARMOR.get());
            multimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(PNEUMATIC_ARMOR_MODIFIERS[equipmentSlot.getIndex()], "Pneumatic Armor modifier boost", (double)upgrades / 2.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(PNEUMATIC_ARMOR_MODIFIERS[equipmentSlot.getIndex()], "Pneumatic Armor toughness boost", (double)upgrades, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public static int getIntData(ItemStack stack, String key, int def) {
        if (stack.getItem() instanceof PneumaticArmorItem && stack.hasTag() && stack.getTag().contains(key, 3)) {
            return stack.getTag().getInt(key);
        }
        return def;
    }

    public static int getIntData(ItemStack stack, String key, int def, int min, int max) {
        if (stack.getItem() instanceof PneumaticArmorItem && stack.hasTag() && stack.getTag().contains(key, 3)) {
            return Mth.clamp((int)stack.getTag().getInt(key), (int)min, (int)max);
        }
        return def;
    }

    public static boolean getBooleanData(ItemStack stack, String key, boolean def) {
        if (stack.getItem() instanceof PneumaticArmorItem && stack.hasTag() && stack.getTag().contains(key, 1)) {
            return stack.getTag().getByte(key) == 1;
        }
        return def;
    }

    public static Item getSearchedItem(ItemStack helmetStack) {
        if (helmetStack.isEmpty() || !NBTUtils.hasTag(helmetStack, NBT_SEARCH_ITEM)) {
            return null;
        }
        String itemName = NBTUtils.getString(helmetStack, NBT_SEARCH_ITEM);
        return itemName.isEmpty() ? null : (Item)BuiltInRegistries.ITEM.get(new ResourceLocation(itemName));
    }

    public static void setSearchedItem(ItemStack helmetStack, Item searchedItem) {
        if (helmetStack.getItem() instanceof PneumaticArmorItem) {
            NBTUtils.setString(helmetStack, NBT_SEARCH_ITEM, PneumaticCraftUtils.getRegistryName(searchedItem).orElseThrow().toString());
        }
    }

    public static BlockPos getCoordTrackerPos(ItemStack helmetStack, Level world) {
        if (helmetStack.isEmpty() || !NBTUtils.hasTag(helmetStack, NBT_COORD_TRACKER)) {
            return null;
        }
        CompoundTag tag = NBTUtils.getCompoundTag(helmetStack, NBT_COORD_TRACKER);
        GlobalPos gPos = GlobalPosHelper.fromNBT(tag);
        if (world.isOutsideBuildHeight(gPos.pos().getY()) || !GlobalPosHelper.isSameWorld(gPos, world)) {
            return null;
        }
        return gPos.pos();
    }

    public static void setCoordTrackerPos(ItemStack helmetStack, GlobalPos gPos) {
        NBTUtils.setCompoundTag(helmetStack, NBT_COORD_TRACKER, GlobalPosHelper.toNBT(gPos));
    }

    public static String getEntityFilter(ItemStack helmetStack) {
        if (helmetStack.isEmpty() || !NBTUtils.hasTag(helmetStack, NBT_ENTITY_FILTER)) {
            return "";
        }
        return NBTUtils.getString(helmetStack, NBT_ENTITY_FILTER);
    }

    public static boolean isPlayerDebuggingDrone(Player player, AbstractDroneEntity e) {
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.getItem() != ModItems.PNEUMATIC_HELMET.get()) {
            return false;
        }
        if (e instanceof DroneEntity) {
            return NBTUtils.getInteger(helmet, "debuggingDrone") == e.getId();
        }
        if (e instanceof ProgrammableControllerEntity) {
            CompoundTag tag = helmet.getTagElement("debuggingPC");
            return tag != null && NbtUtils.readBlockPos((CompoundTag)tag).equals((Object)((ProgrammableControllerEntity)e).getControllerPos());
        }
        return false;
    }

    public static boolean isPlayerDebuggingDrone(Player player, IDroneBase e) {
        ItemStack helmet = player.getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.getItem() != ModItems.PNEUMATIC_HELMET.get()) {
            return false;
        }
        if (e instanceof DroneEntity) {
            return NBTUtils.getInteger(helmet, "debuggingDrone") == ((DroneEntity)e).getId();
        }
        if (e instanceof ProgrammableControllerBlockEntity) {
            CompoundTag tag = helmet.getTagElement("debuggingPC");
            return tag != null && NbtUtils.readBlockPos((CompoundTag)tag).equals((Object)((ProgrammableControllerBlockEntity)e).getBlockPos());
        }
        return false;
    }

    public static IDroneBase getDebuggedDrone() {
        ItemStack helmet = ClientUtils.getClientPlayer().getItemBySlot(EquipmentSlot.HEAD);
        if (helmet.getItem() == ModItems.PNEUMATIC_HELMET.get() && helmet.hasTag()) {
            BlockEntity te;
            Entity e;
            int id;
            CompoundTag tag = Objects.requireNonNull(helmet.getTag());
            if (tag.contains("debuggingDrone") && (id = tag.getInt("debuggingDrone")) > 0 && (e = ClientUtils.getClientLevel().getEntity(id)) instanceof IDroneBase) {
                return (IDroneBase)e;
            }
            if (tag.contains("debuggingPC") && (te = ClientUtils.getClientLevel().getBlockEntity(NbtUtils.readBlockPos((CompoundTag)tag.getCompound("debuggingPC")))) instanceof IDroneBase) {
                return (IDroneBase)te;
            }
        }
        return null;
    }

    @Override
    public float getFOVModifier(ItemStack stack, Player player, EquipmentSlot slot) {
        double boost;
        if (slot == EquipmentSlot.LEGS && (Double)ConfigHelper.client().armor.leggingsFOVFactor.get() > 0.0 && (boost = CommonUpgradeHandlers.runSpeedHandler.getSpeedBoostFromLegs(CommonArmorHandler.getHandlerForPlayer())) > 0.0) {
            return 1.0f + (float)(boost * 2.0 * (Double)ConfigHelper.client().armor.leggingsFOVFactor.get());
        }
        return 1.0f;
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, ModMenuTypes.CHARGING_ARMOR.get());
    }

    @Override
    public boolean shouldShowCustomDurabilityBar(ItemStack stack) {
        return PressurizableItem.shouldShowPressureDurability(stack);
    }

    @Override
    public int getCustomDurabilityColour(ItemStack stack) {
        return PressurizableItem.getPressureDurabilityColor(stack);
    }

    @Override
    public float getCustomDurability(ItemStack stack) {
        return PNCCapabilities.getAirHandler(stack).map(h -> Float.valueOf(h.getPressure() / h.maxPressure())).orElseThrow(RuntimeException::new).floatValue();
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        return switch (tintIndex) {
            case 0 -> this.getColor(stack);
            case 1 -> this.getSecondaryColor(stack);
            case 2 -> {
                if (stack.getItem() == ModItems.PNEUMATIC_HELMET.get()) {
                    yield this.getEyepieceColor(stack);
                }
                yield -1;
            }
            default -> -1;
        };
    }

    public int getColor(ItemStack stack) {
        CompoundTag nbt = stack.getTagElement("display");
        return nbt != null && nbt.contains("color", 99) ? nbt.getInt("color") : -6908266;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        if (wearer instanceof Player) {
            Player player = (Player)wearer;
            Item item = stack.getItem();
            if (item instanceof PneumaticArmorItem) {
                PneumaticArmorItem armor = (PneumaticArmorItem)item;
                return CommonArmorHandler.getHandlerForPlayer(player).getUpgradeCount(armor.type.getSlot(), ModUpgrades.GILDED.get()) > 0;
            }
        }
        return false;
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
        return handler.upgradeUsable(CommonUpgradeHandlers.enderVisorHandler, true);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        if (wearer instanceof Player) {
            Player player = (Player)wearer;
            return CommonArmorHandler.getHandlerForPlayer(player).getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.FLIPPERS.get()) > 0;
        }
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.CREATIVE.get()) == 0;
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        Player player;
        return entity instanceof Player && CommonArmorHandler.getHandlerForPlayer(player = (Player)entity).upgradeUsable(CommonUpgradeHandlers.elytraHandler, true);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return ElytraHandler.handleFlightTick(entity, flightTicks);
    }

    public int getSecondaryColor(ItemStack stack) {
        CompoundTag nbt = stack.getTagElement("display");
        return nbt != null && nbt.contains("color2", 99) ? nbt.getInt("color2") : -4144960;
    }

    public void setSecondaryColor(ItemStack stack, int color) {
        stack.getOrCreateTagElement("display").putInt("color2", color);
    }

    public int getEyepieceColor(ItemStack stack) {
        CompoundTag nbt = stack.getTagElement("display");
        return nbt != null && nbt.contains("color_eye", 99) ? nbt.getInt("color_eye") : -16733696;
    }

    public void setEyepieceColor(ItemStack stack, int color) {
        stack.getOrCreateTagElement("display").putInt("color_eye", color);
    }
}

