/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class PneumaticWrenchItem
extends PressurizableItem {
    public PneumaticWrenchItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        InteractionHand hand = ctx.getHand();
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (!world.isClientSide) {
            BlockState state = world.getBlockState(pos);
            InteractionResult res = ModdedWrenchUtils.getInstance().onWrenchedPre(ctx, state);
            if (res != InteractionResult.PASS) {
                if (res == InteractionResult.SUCCESS) {
                    this.playWrenchSound(world, pos);
                }
                return res;
            }
            IAirHandler airHandler = PNCCapabilities.getAirHandler(stack).orElseThrow(RuntimeException::new);
            boolean didWork = false;
            float pressure = airHandler.getPressure();
            IPneumaticWrenchable wrenchable = IPneumaticWrenchable.forBlock(state.getBlock());
            if (wrenchable != null && pressure > 0.1f) {
                if (wrenchable.onWrenched(world, ctx.getPlayer(), pos, ctx.getClickedFace(), hand)) {
                    if (ctx.getPlayer() != null && !ctx.getPlayer().isCreative()) {
                        airHandler.addAir(-50);
                    }
                    didWork = true;
                }
            } else {
                BlockState rotated = state.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
                if (rotated != state) {
                    world.setBlockAndUpdate(pos, rotated);
                    didWork = true;
                    state = rotated;
                }
            }
            if (didWork) {
                this.playWrenchSound(world, pos);
                ModdedWrenchUtils.getInstance().onWrenchedPost(ctx, state);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private void playWrenchSound(Level world, BlockPos pos) {
        NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.PNEUMATIC_WRENCH.get(), SoundSource.PLAYERS, pos, 1.0f, 1.0f, true), world, pos);
    }

    public InteractionResult interactLivingEntity(ItemStack iStack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (target.isAlive() && target instanceof IPneumaticWrenchable) {
            return PNCCapabilities.getAirHandler(iStack).map(h -> {
                if (!player.isCreative() && h.getAir() < 50) {
                    return InteractionResult.FAIL;
                }
                if (((IPneumaticWrenchable)target).onWrenched(target.level(), player, null, null, hand)) {
                    if (!player.isCreative()) {
                        h.addAir(-50);
                    }
                    this.playWrenchSound(target.level(), target.blockPosition());
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }).orElseThrow(RuntimeException::new);
        }
        return InteractionResult.PASS;
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof ServerPlayer && stack.getItem() instanceof IPressurizableItem && ((IPressurizableItem)stack.getItem()).getPressure(stack) >= 3.0f) {
            ModCriterionTriggers.CHARGED_WRENCH.get().trigger((ServerPlayer)entityIn);
        }
    }
}

