/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Objects;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.registry.ModAttachmentTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;

public class PressurizableItem
extends Item
implements IPressurizableItem,
Vanishable {
    private final int volume;
    private final float maxPressure;

    public PressurizableItem(Item.Properties props, int maxAir, int volume) {
        super(props);
        this.volume = volume;
        this.maxPressure = (float)maxAir / (float)volume;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean isBarVisible(ItemStack pStack) {
        return PressurizableItem.shouldShowPressureDurability(pStack);
    }

    public int getBarWidth(ItemStack stack) {
        return PNCCapabilities.getAirHandler(stack).map(h -> Math.round(h.getPressure() / h.maxPressure() * 13.0f)).orElse(0);
    }

    public int getBarColor(ItemStack pStack) {
        return PressurizableItem.getPressureDurabilityColor(pStack);
    }

    static int getPressureDurabilityColor(ItemStack stack) {
        return PNCCapabilities.getAirHandler(stack).map(airHandler -> {
            float f = airHandler.getPressure() / airHandler.maxPressure();
            int c = (int)(64.0f + 191.0f * f);
            return 0x400000 | c << 8 | 0xFF;
        }).orElse(0xC0C0C0);
    }

    static boolean shouldShowPressureDurability(ItemStack stack) {
        return PNCCapabilities.getAirHandler(stack).map(airHandler -> airHandler.getPressure() < airHandler.maxPressure()).orElse(false);
    }

    @Override
    public int getBaseVolume() {
        return this.volume;
    }

    @Override
    public int getVolumeUpgrades(ItemStack stack) {
        return UpgradableItemUtils.getUpgradeCount(stack, ModUpgrades.VOLUME.get());
    }

    @Override
    public int getAir(ItemStack stack) {
        return (Integer)stack.getData(ModAttachmentTypes.AIR.get());
    }

    @Override
    public float getMaxPressure() {
        return this.maxPressure;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 9;
    }

    public static CompoundTag roundedPressure(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IPressurizableItem) {
            IPressurizableItem p = (IPressurizableItem)item;
            if (stack.getTag() != null && stack.getTag().contains("pneumaticcraft:air")) {
                ItemStack stackCopy = stack.copy();
                CompoundTag tag = Objects.requireNonNull(stackCopy.getTag());
                int air = tag.getInt("pneumaticcraft:air");
                int volume = p.getEffectiveVolume(stackCopy);
                tag.putInt("pneumaticcraft:air", air - air % (volume / (Integer)ConfigHelper.common().advanced.pressureSyncPrecision.get()));
                return tag;
            }
        }
        return stack.getTag();
    }
}

