/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.inventory.RemoteMenu;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RemoteItem
extends Item {
    private static final String NBT_SECURITY_POS = "securityPos";

    public RemoteItem() {
        super(ModItems.defaultProps().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand handIn) {
        ItemStack stack = player.getItemInHand(handIn);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.openGui(sp, stack, handIn);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack remote, UseOnContext ctx) {
        BlockPos pos;
        Player player = ctx.getPlayer();
        Level world = ctx.getLevel();
        BlockEntity te = world.getBlockEntity(pos = ctx.getClickedPos());
        if (te instanceof SecurityStationBlockEntity) {
            SecurityStationBlockEntity teSS = (SecurityStationBlockEntity)te;
            if (player instanceof ServerPlayer && player.isCrouching() && this.isAllowedToEdit(player, remote)) {
                if (teSS.doesAllowPlayer(player)) {
                    GlobalPos gPos = GlobalPosHelper.makeGlobalPos(world, pos);
                    RemoteItem.setSecurityStationPos(remote, gPos);
                    player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.boundSecurityStation", GlobalPosHelper.prettyPrint(gPos)), false);
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.cantBindSecurityStation", new Object[0]), true);
                return InteractionResult.FAIL;
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.openGui(sp, remote, ctx.getHand());
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack remote, Level world, List<Component> curInfo, TooltipFlag moreInfo) {
        super.appendHoverText(remote, world, curInfo, moreInfo);
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tooltip.sneakRightClickToEdit", new Object[0]));
        GlobalPos gPos = RemoteItem.getSecurityStationPos(remote);
        if (gPos != null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tooltip.boundToSecurityStation", GlobalPosHelper.prettyPrint(gPos)));
        } else {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tooltip.rightClickToBind", new Object[0]));
        }
    }

    private void openGui(ServerPlayer player, ItemStack remote, InteractionHand hand) {
        if (player.isCrouching()) {
            if (this.isAllowedToEdit((Player)player, remote)) {
                player.openMenu((MenuProvider)new RemoteEditorContainerProvider(remote, hand), buf -> this.toBytes((FriendlyByteBuf)buf, (Player)player, hand, true));
            }
        } else {
            player.openMenu((MenuProvider)new RemoteContainerProvider(remote, hand), buf -> this.toBytes((FriendlyByteBuf)buf, (Player)player, hand, false));
        }
    }

    private void toBytes(FriendlyByteBuf buf, Player player, InteractionHand hand, boolean syncGlobals) {
        buf.writeBoolean(hand == InteractionHand.MAIN_HAND);
        if (syncGlobals) {
            Collection<String> variables = GlobalVariableManager.getInstance().getAllActiveVariableNames(player);
            buf.writeVarInt(variables.size());
            variables.forEach(arg_0 -> ((FriendlyByteBuf)buf).writeUtf(arg_0));
        } else {
            buf.writeVarInt(0);
        }
    }

    public static boolean hasSameSecuritySettings(ItemStack remote1, ItemStack remote2) {
        GlobalPos g1 = RemoteItem.getSecurityStationPos(remote1);
        GlobalPos g2 = RemoteItem.getSecurityStationPos(remote2);
        return g1 == null && g2 == null || g1 != null && g1.equals((Object)g2);
    }

    private boolean isAllowedToEdit(Player player, ItemStack remote) {
        BlockEntity te;
        GlobalPos gPos = RemoteItem.getSecurityStationPos(remote);
        if (gPos != null && (te = GlobalPosHelper.getTileEntity(gPos)) instanceof SecurityStationBlockEntity) {
            boolean canAccess = ((SecurityStationBlockEntity)te).doesAllowPlayer(player);
            if (!canAccess) {
                player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.gui.remote.noEditRights", (Object[])new Object[]{gPos}).withStyle(ChatFormatting.RED), false);
            }
            return canAccess;
        }
        return true;
    }

    private static GlobalPos getSecurityStationPos(ItemStack stack) {
        return stack.hasTag() && Objects.requireNonNull(stack.getTag()).contains(NBT_SECURITY_POS) ? GlobalPosHelper.fromNBT(stack.getTag().getCompound(NBT_SECURITY_POS)) : null;
    }

    private static void setSecurityStationPos(ItemStack stack, GlobalPos gPos) {
        NBTUtils.setCompoundTag(stack, NBT_SECURITY_POS, GlobalPosHelper.toNBT(gPos));
    }

    public void inventoryTick(ItemStack remote, Level world, Entity entity, int slot, boolean holdingItem) {
        BlockEntity te;
        GlobalPos gPos;
        if (!world.isClientSide && (gPos = RemoteItem.getSecurityStationPos(remote)) != null && !((te = GlobalPosHelper.getTileEntity(gPos)) instanceof SecurityStationBlockEntity) && remote.hasTag()) {
            Objects.requireNonNull(remote.getTag()).remove(NBT_SECURITY_POS);
        }
    }

    static class RemoteEditorContainerProvider
    extends RemoteContainerProvider {
        RemoteEditorContainerProvider(ItemStack stack, InteractionHand hand) {
            super(stack, hand);
        }

        @Override
        protected MenuType<? extends RemoteMenu> getType() {
            return ModMenuTypes.REMOTE_EDITOR.get();
        }
    }

    static class RemoteContainerProvider
    implements MenuProvider {
        private final ItemStack stack;
        private final InteractionHand hand;

        RemoteContainerProvider(ItemStack stack, InteractionHand hand) {
            this.stack = stack;
            this.hand = hand;
        }

        public Component getDisplayName() {
            return this.stack.getHoverName();
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
            return new RemoteMenu(this.getType(), windowId, playerInventory, this.hand);
        }

        protected MenuType<? extends RemoteMenu> getType() {
            return ModMenuTypes.REMOTE.get();
        }
    }
}

