/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.registry.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class SeismicSensorItem
extends Item {
    private static final int MAX_SEARCH = 500;

    public SeismicSensorItem() {
        super(ModItems.defaultProps().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (level.isClientSide && player != null) {
            BlockPos.MutableBlockPos searchPos = ctx.getClickedPos().mutable();
            this.findFluid(level, (BlockPos)searchPos).ifPresentOrElse(result -> {
                int bottomOff;
                int topOff = ctx.getClickedPos().getY() - result.top().getY();
                Object depthStr = topOff == (bottomOff = ctx.getClickedPos().getY() - result.bottom().getY()) ? Integer.toString(topOff) : topOff + "-" + bottomOff;
                player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.seismicSensor.foundOilDetails", (Object[])new Object[]{Component.translatable((String)result.fluid().getFluidType().getDescriptionId()), ChatFormatting.GREEN + (String)depthStr, ChatFormatting.GREEN.toString() + result.lakeSize()}), false);
                player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), 1.0f, 1.0f);
            }, () -> player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.seismicSensor.noOilFound"), false));
        }
        return InteractionResult.SUCCESS;
    }

    private Optional<FluidSearchResult> findFluid(Level level, BlockPos origin) {
        BlockPos.MutableBlockPos searchPos = origin.mutable();
        while (searchPos.getY() > level.getMinBuildHeight()) {
            searchPos.move(Direction.DOWN);
            Fluid fluid = this.getFluidOfInterest(level, (BlockPos)searchPos);
            if (fluid == null) continue;
            BlockPos top = searchPos.immutable();
            do {
                searchPos.move(Direction.DOWN);
            } while (searchPos.getY() > level.getMinBuildHeight() && this.getFluidOfInterest(level, (BlockPos)searchPos) == fluid);
            BlockPos bottom = searchPos.above().immutable();
            Set<BlockPos> fluidPositions = this.findLake(level, top, fluid);
            int lakeSize = Math.max(1, fluidPositions.size() / 10 * 10);
            return Optional.of(new FluidSearchResult(fluid, top, bottom, lakeSize));
        }
        return Optional.empty();
    }

    private Fluid getFluidOfInterest(Level world, BlockPos pos) {
        FluidState state = world.getFluidState(pos);
        return state.getType().is(PneumaticCraftTags.Fluids.SEISMIC) ? state.getType() : null;
    }

    private Set<BlockPos> findLake(Level world, BlockPos searchPos, Fluid fluid) {
        HashSet<BlockPos> fluidPositions = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> pendingPositions = new ArrayDeque<BlockPos>();
        pendingPositions.add(searchPos);
        while (!pendingPositions.isEmpty() && fluidPositions.size() < 500) {
            BlockPos checkingPos = (BlockPos)pendingPositions.pop();
            for (Direction d : Direction.values()) {
                BlockPos newPos;
                FluidState state;
                if (d == Direction.UP || (state = world.getFluidState(newPos = checkingPos.relative(d))).getType() != fluid || !state.isSource() || !fluidPositions.add(newPos)) continue;
                pendingPositions.add(newPos);
            }
        }
        return fluidPositions;
    }

    record FluidSearchResult(Fluid fluid, BlockPos top, BlockPos bottom, int lakeSize) {
    }
}

