/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableInt;

public class SpawnerCoreItem
extends Item
implements ColorHandlers.ITintableItem {
    private static final String NBT_SPAWNER_CORE = "pneumaticcraft:SpawnerCoreStats";

    public SpawnerCoreItem() {
        super(ModItems.defaultProps());
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        SpawnerCoreStats stats = SpawnerCoreStats.forItemStack(stack);
        if (stats != null) {
            if (stats.getUnusedPercentage() < 100) {
                stats.getEntities().stream().sorted(Comparator.comparing(t -> I18n.get((String)t.getDescriptionId(), (Object[])new Object[0]))).forEach(type -> tooltip.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate(type.getDescriptionId(), new Object[0]).withStyle(ChatFormatting.YELLOW)).append(": " + stats.getPercentage((EntityType<?>)type) + "%").withStyle(ChatFormatting.WHITE)));
                if (stats.getUnusedPercentage() > 0) {
                    tooltip.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})).append(": " + stats.getUnusedPercentage() + "%").withStyle(ChatFormatting.WHITE));
                }
            } else {
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide) {
            return this.trySpawnEntity(context) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private boolean trySpawnEntity(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        if (stack.getCount() != 1) {
            return false;
        }
        SpawnerCoreStats stats = SpawnerCoreStats.forItemStack(stack);
        if (stats != null) {
            Level world = context.getLevel();
            EntityType<?> type = stats.pickEntity(false);
            if (type == null) {
                return false;
            }
            return PneumaticCraftUtils.getRegistryName(BuiltInRegistries.ENTITY_TYPE, type).map(regName -> {
                Vec3 vec = context.getClickLocation();
                if (world.noCollision(type.getAABB(vec.x(), vec.y(), vec.z()))) {
                    ServerLevel serverworld = (ServerLevel)world;
                    CompoundTag nbt = new CompoundTag();
                    nbt.putString("id", regName.toString());
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)world, e1 -> {
                        e1.moveTo(vec.x(), vec.y(), vec.z(), e1.getYRot(), e1.getXRot());
                        return e1;
                    });
                    if (entity != null) {
                        entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), world.random.nextFloat() * 360.0f, 0.0f);
                        if (serverworld.tryAddFreshEntityWithPassengers(entity)) {
                            stats.addAmount(type, -1);
                            stats.serialize(stack);
                            return true;
                        }
                    }
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        SpawnerCoreStats stats;
        if (tintIndex == 1 && (stats = SpawnerCoreStats.forItemStack(stack)) != null) {
            if (stats.getUnusedPercentage() == 100) {
                return -1;
            }
            int t = (int)(ClientUtils.getClientLevel().getGameTime() % 40L);
            float b = t < 20 ? Mth.sin((float)((float)Math.PI * (float)t / 20.0f)) / 6.0f : 0.0f;
            return TintColor.HSBtoRGB(0.19722222f, 1.0f - (float)stats.getUnusedPercentage() / 100.0f, 0.83333f + b);
        }
        return -1;
    }

    public static class SpawnerCoreStats
    implements ISpawnerCoreStats {
        private final Map<EntityType<?>, Integer> entityCounts = new HashMap();
        private int unused;

        private SpawnerCoreStats(ItemStack stack) {
            CompoundTag nbt0 = stack.getTag();
            MutableInt total = new MutableInt(0);
            if (nbt0 != null && nbt0.contains(SpawnerCoreItem.NBT_SPAWNER_CORE)) {
                CompoundTag nbt = nbt0.getCompound(SpawnerCoreItem.NBT_SPAWNER_CORE);
                for (String k : nbt.getAllKeys()) {
                    BuiltInRegistries.ENTITY_TYPE.getOptional(new ResourceLocation(k)).ifPresent(type -> {
                        int amount = nbt.getInt(k);
                        this.entityCounts.put((EntityType<?>)type, amount);
                        total.add(amount);
                    });
                }
            }
            this.unused = Math.max(0, 100 - total.intValue());
        }

        static SpawnerCoreStats forItemStack(ItemStack stack) {
            return stack.getItem() instanceof SpawnerCoreItem ? new SpawnerCoreStats(stack) : null;
        }

        @Override
        public void serialize(ItemStack stack) {
            if (stack.getItem() instanceof SpawnerCoreItem) {
                if (this.unused == 100) {
                    CompoundTag tag = stack.getTag();
                    if (tag != null) {
                        tag.remove(SpawnerCoreItem.NBT_SPAWNER_CORE);
                    }
                } else {
                    CompoundTag subTag = stack.getOrCreateTagElement(SpawnerCoreItem.NBT_SPAWNER_CORE);
                    this.entityCounts.forEach((type, amount) -> PneumaticCraftUtils.getRegistryName(BuiltInRegistries.ENTITY_TYPE, type).ifPresent(regName -> {
                        if (amount > 0) {
                            subTag.putInt(regName.toString(), amount.intValue());
                        } else {
                            subTag.remove(regName.toString());
                        }
                    }));
                }
            } else {
                throw new IllegalArgumentException("item is not a spawner core!");
            }
        }

        @Override
        public Set<EntityType<?>> getEntities() {
            return this.entityCounts.keySet();
        }

        @Override
        public int getPercentage(EntityType<?> entityType) {
            return this.entityCounts.getOrDefault(entityType, 0);
        }

        @Override
        public int getUnusedPercentage() {
            return this.unused;
        }

        @Override
        public boolean addAmount(EntityType<?> type, int toAdd) {
            int current = this.entityCounts.getOrDefault(type, 0);
            if ((toAdd = Mth.clamp((int)toAdd, (int)(-current), (int)this.unused)) != 0) {
                int newAmount = Mth.clamp((int)(current + toAdd), (int)0, (int)100);
                this.entityCounts.put(type, newAmount);
                this.unused -= toAdd;
                return true;
            }
            return false;
        }

        @Override
        public EntityType<?> pickEntity(boolean includeUnused) {
            if (this.unused == 100) {
                return null;
            }
            ArrayList<WeightedEntity> weightedEntities = new ArrayList<WeightedEntity>();
            this.entityCounts.forEach((type, amount) -> weightedEntities.add(new WeightedEntity((EntityType<?>)type, (int)amount)));
            if (includeUnused) {
                weightedEntities.add(new WeightedEntity(null, this.unused));
            }
            return WeightedRandom.getRandomItem((RandomSource)RandomSource.createNewThreadLocalInstance(), weightedEntities).map(WeightedEntity::type).orElse(null);
        }

        private record WeightedEntity(EntityType<?> type, int weight) implements WeightedEntry
        {
            public Weight getWeight() {
                return Weight.of((int)this.weight);
            }
        }
    }

    public static class SpawnerCoreItemHandler
    extends BaseItemStackHandler {
        private ISpawnerCoreStats stats;

        public SpawnerCoreItemHandler(BlockEntity owner) {
            super(owner, 1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getItem() instanceof SpawnerCoreItem;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                this.readSpawnerCoreStats();
            }
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.readSpawnerCoreStats();
        }

        public ISpawnerCoreStats getStats() {
            return this.stats;
        }

        private void readSpawnerCoreStats() {
            this.stats = this.getStackInSlot(0).isEmpty() ? null : SpawnerCoreStats.forItemStack(this.getStackInSlot(0));
        }
    }
}

