/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IFilteringItem;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;

public class TagFilterItem
extends Item
implements IFilteringItem {
    private static final String NBT_TAG_LIST = "TagList";

    public TagFilterItem() {
        super(ModItems.defaultProps().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        if (worldIn != null) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.tag_filter.header", new Object[0]).withStyle(ChatFormatting.YELLOW));
            for (TagKey<Item> key : TagFilterItem.getConfiguredTagList(stack)) {
                tooltip.add((Component)Symbols.bullet().append(key.location().toString()).withStyle(ChatFormatting.GOLD));
            }
        }
    }

    public static Set<TagKey<Item>> getConfiguredTagList(ItemStack stack) {
        CompoundTag nbt = stack.getTag();
        if (nbt != null && nbt.contains(NBT_TAG_LIST)) {
            ListTag l = nbt.getList(NBT_TAG_LIST, 8);
            HashSet<TagKey<Item>> res = new HashSet<TagKey<Item>>();
            for (int i = 0; i < l.size(); ++i) {
                res.add((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation(l.getString(i))));
            }
            return res;
        }
        return Sets.newHashSet();
    }

    public static void setConfiguredTagList(ItemStack stack, Set<TagKey<Item>> tags) {
        ListTag l = new ListTag();
        tags.forEach(tagKey -> l.add((Object)StringTag.valueOf((String)tagKey.location().toString())));
        stack.getOrCreateTag().put(NBT_TAG_LIST, (Tag)l);
    }

    @Override
    public boolean matchFilter(ItemStack filterStack, ItemStack stack) {
        Validate.isTrue((boolean)(filterStack.getItem() instanceof TagFilterItem), (String)"filtering itemstack is not a tag filter!", (Object[])new Object[0]);
        Set<TagKey<Item>> tags = TagFilterItem.getConfiguredTagList(filterStack);
        return !Sets.intersection(tags, PneumaticCraftUtils.itemTags(stack.getItem())).isEmpty();
    }
}

