/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.upgrade.IUpgradeItem;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.item.CreativeTabStackProvider;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class UpgradeItem
extends Item
implements IUpgradeItem,
CreativeTabStackProvider {
    public static final String NBT_DIRECTION = "Facing";
    private final PNCUpgrade upgrade;
    private final int tier;

    public UpgradeItem(PNCUpgrade upgrade, int tier) {
        this(upgrade, tier, ModItems.defaultProps());
    }

    public UpgradeItem(PNCUpgrade upgrade, int tier, Item.Properties properties) {
        super(properties);
        this.upgrade = upgrade;
        this.tier = tier;
    }

    @Override
    public PNCUpgrade getUpgradeType() {
        return this.upgrade;
    }

    @Override
    public int getUpgradeTier() {
        return this.tier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level world, List<Component> infoList, TooltipFlag par4) {
        if (ClientUtils.hasShiftDown()) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.upgrade.usedIn", new Object[0]).withStyle(ChatFormatting.AQUA));
            PneumaticRegistry.getInstance().getUpgradeRegistry().addUpgradeTooltip(this.upgrade, infoList);
        } else {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.item.upgrade.shiftMessage", new Object[0]).withStyle(ChatFormatting.AQUA));
        }
        if (this.getUpgradeType() == ModUpgrades.DISPENSER.get()) {
            Direction dir = stack.hasTag() ? Direction.byName((String)NBTUtils.getString(stack, NBT_DIRECTION)) : null;
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.dispenser.direction", dir == null ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.any", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.direction." + dir.getSerializedName(), new Object[0])));
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.dispenser.clickToSet", new Object[0]));
        }
        super.appendHoverText(stack, world, infoList, par4);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (this.getUpgradeType() == ModUpgrades.DISPENSER.get()) {
            Player player = context.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                this.setDirection(sp, context.getHand(), context.getClickedFace());
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (this.getUpgradeType() == ModUpgrades.DISPENSER.get()) {
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)playerIn;
                this.setDirection(sp, handIn, null);
            }
            return InteractionResultHolder.success((Object)playerIn.getItemInHand(handIn));
        }
        return super.use(worldIn, playerIn, handIn);
    }

    private void setDirection(ServerPlayer player, InteractionHand hand, Direction facing) {
        ItemStack stack = player.getItemInHand(hand);
        if (facing == null) {
            stack.setTag(null);
            player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.dispenser.direction", (Object[])new Object[]{"*"}), true);
        } else {
            NBTUtils.setString(stack, NBT_DIRECTION, facing.getSerializedName());
            player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.dispenser.direction", (Object[])new Object[]{facing.getSerializedName()}), true);
        }
    }

    public Rarity getRarity(ItemStack stack) {
        return this.getUpgradeType() == ModUpgrades.CREATIVE.get() ? Rarity.EPIC : Rarity.COMMON;
    }

    public static UpgradeItem of(ItemStack stack) {
        return (UpgradeItem)stack.getItem();
    }

    @Override
    public Stream<ItemStack> getStacksForItem() {
        return Stream.of(new ItemStack((ItemLike)this));
    }
}

