/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.minigun;

import java.util.List;
import me.desht.pneumaticcraft.common.PNCDamageSource;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractGunAmmoItem
extends Item {
    public AbstractGunAmmoItem() {
        super(ModItems.defaultProps().stacksTo(1).setNoRepair().defaultDurability(1000));
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().minigun.standardAmmoCartridgeSize.get();
    }

    public float getRangeMultiplier(ItemStack ammoStack) {
        return 1.0f;
    }

    public float getAirUsageMultiplier(Minigun minigun, ItemStack ammoStack) {
        return 1.0f;
    }

    protected float getDamageMultiplier(Entity target, ItemStack ammoStack) {
        return 1.0f;
    }

    public abstract int getAmmoColor(ItemStack var1);

    public int getAmmoCost(ItemStack ammoStack) {
        return 1;
    }

    protected DamageSource getDamageSource(Minigun minigun) {
        return PNCDamageSource.minigun(minigun.getPlayer().level(), (Entity)minigun.getPlayer());
    }

    public void appendHoverText(ItemStack stack, Level world, List<Component> infoList, TooltipFlag extraInfo) {
        infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo.ammoRemaining", stack.getMaxDamage() - stack.getDamageValue(), stack.getMaxDamage()));
        super.appendHoverText(stack, world, infoList, extraInfo);
    }

    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        int times = 1;
        int nSpeed = minigun.getUpgrades(ModUpgrades.SPEED.get());
        for (int i = 0; i < nSpeed; ++i) {
            if (minigun.getWorld().random.nextInt(100) >= 20) continue;
            ++times;
        }
        double dmgMult = this.getDamageMultiplier(target, ammo);
        if (dmgMult > 0.0) {
            if (target instanceof LivingEntity || target instanceof EnderDragonPart || target instanceof EndCrystal) {
                target.hurt(this.getDamageSource(minigun), (float)((Double)ConfigHelper.common().minigun.baseDamage.get() * dmgMult * (double)times));
            } else if (target instanceof ShulkerBullet || target instanceof AbstractHurtingProjectile) {
                target.discard();
            }
        }
        return times;
    }

    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockHitResult brtr) {
        return 1;
    }
}

